/*
 * This file is #included by sendnews.c and recvnews.c.  It contains
 * shared routines.
 */


/*
 * list all the files in a directory.
 */

lsdir(dname, l)
      char *dname ;
      struct arglist *l ;
      {
      DIR *dp ;
      struct direct *d ;
      int oflow ;

      l->nargs = 0 ;
      oflow = 0 ;
      if ((dp = opendir(dname)) == NULL)
            fatal("Can't open %s", dname) ;
      while ((d = readdir(dp)) != NULL) {
            if (d->d_name[0] == '.')
                  continue ;
            if (badname(d->d_name)) {
                  msg("bad file name %s", d->d_name) ;
                  cd(dname) ;
                  movebad(d->d_name) ;
                  cd("") ;
                  continue ;
            }
            if (l->nargs < MAXARGS)
                  addarg(d->d_name, l) ;
            else
                  oflow++ ;
      }
      closedir(dp) ;
      if (oflow)
            msg("Too many files in %s; %d not processed", dname, oflow) ;
      qsort((char *)(l->arg), l->nargs, sizeof(char *), comp) ;
}



/*
 * Return true if fname is not the name of a file generated by xfernews.
 */

badname(fname)
      char *fname ;
      {
      register c ;

      if ((c = *fname++) != 'a' && c != 'n' && c != 'm' && c != 'b')
            return -1 ;
      if ((c = *fname++) < '0' || c > '9')
            return -1 ;
      return 0 ;
}



movebad(fname)
      char *fname ;
      {
      char bad[PATHLEN] ;

      sprintf(bad, "../bad/%s", fname) ;
      mv(fname, bad, 1) ;
}



comp(a, b)
      char **a, **b ;
      {
      return strcmp(*a, *b) ;
}



addarg(fname, argl)
      struct arglist *argl ;
      char *fname ;
      {
      char *p ;

      if (argl->nargs >= MAXARGS)
            fatal("too many articles") ;
      if (fname == NULL)
            p = NULL ;
      else {
            if ((p = malloc(strlen(fname) + 1)) == NULL)
                  fatal("out of space") ;
            strcpy(p, fname) ;
      }
      argl->arg[argl->nargs++] = p ;
}



#ifdef RECVNEWS
/*
 * Run a program, informing the system administrator if it fails.
 */

chkrun(arg, name, fp)
      char *arg[] ;
      char *name ;
      FILE *fp ;
      {
      char *p ;
      int outfd ;
      int rc ;
      FILE *mailfp ;
      static char outfile[24] ;

      if (outfile[0] == '\0')
            sprintf(outfile, "/tmp/recvnews%d", getpid()) ;
      if ((outfd = creat(outfile, 0666)) < 0)
            fatal("Can't create %s", outfile) ;
      rc = run(arg, fileno(fp), outfd) ;
      close(outfd) ;
      if (rc != 0) {
            if ((mailfp = popen(MAILCMD, "w")) == NULL)
                  fatal("Can't popen MAILCMD") ;
            fprintf(mailfp, "Subject:  error in recvnews\n\n") ;
            if ((rc & 0177) == 0) {
                  fprintf(mailfp, "exit status %d from %s", rc >> 8, arg[0]) ;
            } else {
                  fprintf(mailfp, "%s died with signal %d", arg[0], rc & 0177) ;
                  if (rc & 0200)
                        fprintf(mailfp, " - core dumped") ;
            }
            fprintf(mailfp, "\nfile %s/bad/%s\n", directory, name) ;
            if ((fp = fopen(outfile, "r")) == NULL)
                  fprintf(mailfp, "Can't open %s\n", outfile) ;
            else {
                  fprintf(mailfp, "Output of program:\n") ;
                  while ((rc = getc(fp)) != EOF)
                        putc(rc, mailfp) ;
                  fclose(fp) ;
            }
            pclose(mailfp) ;
            if (unlink(outfile) < 0)
                  msg("can't unlink %s", outfile) ;
            return rc == (33<<8)? -2 : -1 ;
      }
      if (unlink(outfile) < 0)
            msg("can't unlink %s", outfile) ;
      return 0 ;
}
#endif


/*
 * Run a program.  In and out are the file descriptors to redirect to.
 */

run(args, in, out)
      char *args[] ;
      int in, out ;
      {
      int pid ;
      int status ;
      int i ;

#ifdef DEBUG
      printf("run") ;				/*DEBUG*/
      for (i = 0 ; args[i] != NULL ; i++)	/*DEBUG*/
            printf(" %s", args[i]) ;		/*DEBUG*/
      putchar('\n') ;				/*DEBUG*/
#endif
      if ((pid = fork()) == -1)
            fatal("Cannot fork") ;
      if (pid == 0) {
            if (in != 0) {
                  close(0) ;
                  if (dup(in) != 0) {
                        msg("Cannot redirect input") ;
                        exit(127) ;
                  }
                  close(in) ;
            }
            if (out != 1) {
                  close(1) ;
                  if (dup(out) != 1) {
                        msg("Cannot redirect output") ;
                        exit(127) ;
                  }
                  close(out) ;
                  close(2) ;
                  if (dup(1) != 2) {
                        msg("Cannot dup 1") ;
                        exit(127) ;
                  }
            }
            execv(args[0], args) ;
            msg("exec failed") ;
            exit(127) ;
      }
      while ((i = wait(&status)) != pid && i != -1) ;
      return status ;
}



/*
 * Return the size of an open file.
 */

long
fsize(fd) {
      struct stat st ;

      if (fstat(fd, &st) < 0)
            return 0L ;
      return st.st_size ;
}


/*
 * Remove a file, with fatal message on error.
 */

rm(fname)
      char *fname ;
      {
      if (unlink(fname) < 0)
            fatal("Can't unlink %s", fname) ;
}



/*
 * Rename a file.  If zapflag is set, then "to" is deleted if it exists.
 */

mv(from, to, zapflag)
      char *from, *to ;
      {
      if (link(from, to) < 0) {
            if (errno != EEXIST || ! zapflag)
bad:              fatal("mv %s %s failed", from, to) ;
            if (unlink(to) < 0 || link(from, to) < 0)
                  goto bad ;
      }
      rm(from) ;
}


/*
 * Change directory.  If the directory name begins with a slash, then it
 * is interpreted relative to the root.  Otherwise, it is relative to the
 * last directory changed to that did begin with a slash.
 */

cd(dir)
      char *dir ;
      {
      static char *olddir ;
      char dstr[20] ;

      if (dir[0] == '/')
            olddir = "" ;
      else if (equal(dir, olddir))
            return ;
      else if (olddir[0]) {
            olddir = dir ;
            if (dir[0]) {
                  sprintf(dstr, "../%s", dir) ;
                  dir = dstr ;
            } else
                  dir = ".." ;
      } else
            olddir = dir ;
      if (chdir(dir) < 0)
            fatal("Can't chdir to %s", dir) ;
}



FILE *
ckopen(fname, mode)
      char *fname, *mode ;
      {
      FILE *fp ;

      if ((fp = fopen(fname, mode)) == NULL)
            fatal(equal(mode, "w")? "Can't create %s" : "Can't open %s", fname) ;
      return fp ;
}



/*
 * Fatal error.
 * Print error message and send mail to administrator.
 */

fatal(fmt, a1, a2, a3, a4)
      char *fmt ;
      {
      static int reentered = 0 ;

      if (reentered) {
            fprintf(stderr, "fatal entered recursively\n") ;
            fprintf(stderr, fmt, a1, a2, a3, a4) ;
            exit(3) ;
      }
      reentered = 1 ;
      msg(fmt, a1, a2, a3, a4) ;
      reentered = 0 ;
#ifdef RECVNEWS
      reset() ;
#else
      exit(2) ;
#endif
}


/*
 * Send mail to administrator.
 */

msg(fmt, a1, a2, a3, a4)
      char *fmt ;
      {
      FILE *fp ;
      int fd ;

      errflag = 1 ;
      fprintf(stderr, fmt, a1, a2, a3, a4) ;
      putc('\n', stderr) ;

      /* be sure stdin is open; otherwise popen won't work */
      if ((fd = open("/dev/null", 0)) > 0)
            close(fd) ;
      if ((fp = popen(MAILCMD, "w")) == NULL)
            fatal("popen failed") ;
#ifdef RECVNEWS
      fputs("Subject:  error in recvnews\n\n", fp) ;
#else
      fputs("Subject:  error in sendnews\n\n", fp) ;
#endif
      fprintf(fp, fmt, a1, a2, a3, a4) ;
      if (directory != NULL) {
            fputs("\nprocessing ", fp) ;
            fputs(directory, fp) ;
      }
      putc('\n', fp) ;
      if (pclose(fp) != 0)
            fatal("msg failed") ;
}
