.TH VN 1 2/1/85
.UC
.SH NAME
vn - visual news reader
.SH SYNOPSIS
.I vn
.SH DESCRIPTION
.I Vn
is a news reader which uses the same 
.B .newsrc
file as
.I readnews
(1), but displays and interacts differently.  It is aimed at allowing
you to rapidly scan a large number of newsgroups, looking for something
you want to read.  The major premise is that you will be interested in a
small number of articles, but will be interested in keeping tabs on a large
number of newsgroups which may contain something interesting from time to time.
It also has the ability to unpackage digests.
.sp
.I Vn
supports the -n, -x and -t options of
.I readnews
(newsgroup, read all articles, and title).  In addition, there
is a -w (writer) option which works like -t, but is a search string to
apply to the "From" header line rather than the subject.  In the -n, -t
and -w options, a leading ! on the string is taken to mean negation.
The rest of the string is a regular expression for the -w and -t options.
.sp
For example:
.sp
-n net.dogs -w !fred -t [Bb]eagle
.sp
For articles in net.dogs about beagles written by somebody other
than fred.  Multiple -w -t options are treated as follows:
.in +5
.sp
If the article satisfies any of the negations, you won't see it,
regardless of the non-negated options.
.sp
Multiple -w options are logically "or'ed", as are multiple -t's.
.sp
If both -w and -t are present, the article is seen only if it satisfies
at least one of the -w's and at least one of the -t's, ie. the results of the
logical "or's" of the -t's and -w's are logically "anded".
.sp
.in -5
The -n options allow the "all" convention, replacing ".all" by
".*" before using the regular expression calls.  -n options are processed
in order given, so that subsequent more specific -n's may partially
undo the effect of previous "alls".  Note that the -n option
treatment is slightly different than the
.I readnews
treatment which says that "foo" implies "foo.all".
.I Vn
accepts this incompatibility to allow you an easier way of saying JUST "foo"
without any of its subgroups.
.sp
Options may be given on the command line, in which case they will
supersede those given in the
.B .newsrc
file.  For command line -n options, the "!" unsubscriptions in
.B .newsrc
are also ignored.  This allows you to override all subscription information
by command line specification.  If you use an -S option on the command line,
the "!" unsubscriptions will still be used.  -S is meaningless in the
.B .newsrc
file.
.sp
There are three more options specific to
.I vn:
the -% and -U.  The -% option initially gives you the results of a "%"
command, rather than the page for the first newsgroup (see below).
This allows you to see what newsgroups are available before viewing any.
The -U option says that when your
.B .newsrc
file is updated via answering "yes" to the update query on
exit or using control-W, newsgroups marked with "!" are to be updated too.
Normally, these groups are left alone, ie. updated only to the number that
was already in your
.B .newsrc,
or the lowest article number still around.
You may get flooded should you decide to resubscribe.
If you don't like this treatment, use -U.  Then, control-W and "yes" to
the update on exit will update your unsubscribed newsgroups to the most
recent article.
.sp
When
.I vn
is invoked,
there will be a pause (with an explanatory "reading" message and
a series of newsgroups) while vn reads the news.  The newsgroups listed
are ones articles are actually being found in.
The length of the pause depends
on how much news there is.  If there is a lot,
it may take a long time to get through the reading phase.
.sp
Once the reading phase is over, interaction is rapid.
If
.I vn
is backgrounded, it suppresses the "reading" output, so
that it will not halt on tty output until it is ready to begin showing
articles.
.sp
.I Vn
may show you a list of newsgroups which were not mentioned in the
.B .newsrc
file.  Records for these newsgroups will be added, whether
they were scanned for articles or not.  The first time
.I vn
is used, the list may be quite long and scroll off the screen.
Thereafter, there should only be a list when new newsgroups are
created.  This display serves to let you know of their existence,
or of something happening to your
.B .newsrc
file.
.sp
The basic display is a "page" which shows a newsgroup and a list of
titles, number of
lines, and authors for new articles.
Articles which have been updated in the
.B .newsrc
file  are flagged with an underscore preceding the article number.
You also have the ability to "mark" articles for the duration of a session,
shown with an asterisk (col. 1 and 2 are reserved for asterisk and
underscore respectively - 
in normal usage they will be blank, so that the casual user will probably
be unaware of their use until marking and updating are invoked)
.sp
There is a help menu to go with this page.
You may read articles, save them, send them to the printer, either by cursor
position, the whole page, or in specified sets.  Sets are specified either
as a set of article numbers, a regular expression to match the subject /
author / number of lines data on, or an asterisk to indicate the choice
of a set of previously marked articles.  Any of these methods also
accept a leading "!" to indicate negation.
.sp
By default, when you read articles only a couple of the dozen or so
header lines are
shown.  There is an option to allow you to see all the
header lines when you read articles.  The command controlling this toggles
between the two states.
.sp
A similar toggle is used to support ROT13.
.sp
.I Vn
is capable of manipulating digests.  The "d" command unpacks a digest,
and presents you with a page showing the unpacked articles, which can
be accessed as for articles on normal newsgroup pages.
When you leave the digest page(s), you reenter the normal flow of newsgroups.
Digests can also be read as normal articles, of course.
.sp
Order of pages is determined by
order of groups in
.B .newsrc.
Newsgroups which are not
mentioned in
.B .newsrc
will be added, as mentioned previously, and tacked onto the end.
Lines corresponding to non-existent newsgroups will be deleted.
You will probably want to run
.I vn
once, then edit
.B .newsrc
to the desired order of presentation.
.sp
Updating the data for
.B .newsrc
is under user control.  If you do
no "W", "w", "^w", o or O commands, no updating takes place, and you'll see the
articles again the next time you read news.
If you quit without updating, you will be prompted to make sure you
don't want to do so.
.sp
Note that "updating what you've seen" to
.I vn
means that you've seen the page presentation, not that you've read the
article.  This is consistent with the overall assumption that you don't
want to read most of what you are presented with.
.sp
Breaks result in a "really quit?" query, so you can recover from noisy
lines and prompts for commands you didn't really mean.  If you answer no,
you are simply jumped back to the page.  Breaks while in the midst of scrolling
out an article you are reading jump you to the end of the article to stop
the output.
.sp
Commands are single character (no return key required), except that
they may be preceded with numeric characters, which may have
some effect on their actions.  Commands which require further input
cause prompts for the information, this input being
terminated by return.  For prompted input, the erase and kill keys
work.
.sp
.ce 1
Command Menu For Page:
.sp
.nf
[...] = effect of optional number preceding command
pipes are specified by filenames beginning with |
articles specified as a list of numbers, title search string, or
	* to specify marked articles.  ! may be used to negate any

	 q - quit
	 k - (or up arrow) move up [number of lines]
	 j - (or down arrow) move down [number of lines]
 <back sp> - (or left arrow) previous page [number of pages]
  <return> - (or right arrow) next page [number of pages]
	 d - unpack digest
	 r - read article [number of articles]
   <space> - read article (alternate 'r')
	 R - read all articles on page
 control-r - specify articles to read
	 s - save or pipe article [number of articles]
	 S - save or pipe all articles on page
 control-s - specify articles to save
 control-t - specify articles to save (alternate ctl-s)
	 p - print article [number of articles]
	 P - print all article on page
 control-p - specify articles to print
	 w - update .newsrc status to cursor
	 W - update .newsrc status for whole newsgroup
 control-w - update .newsrc status for all pages displayed
	 o - recover original .newsrc status for newsgroup
	 O - recover all original .newsrc status
	 # - display count of groups and pages - shown and total
	 % - list newsgroups with new article, updated counts
	 n - specify newsgroup to display and/or resubscribe to
	 u - unsubscribe from group
	 x - mark/unmark article [number of articles]
	 * - mark/unmark article [number of articles]
	 X - erase marks on articles
	 h - toggle flag for display of headers when reading
	 z - toggle rotation for reading
<formfeed> - redraw screen
	 ! - escape to UNIX to execute a command
	 ? - show this help menu
.fi
.sp
When you read articles, there is another help menu, for advancing through
the articles, replying, posting followups, and saving the
articles.  Breaks may be used to
stop the output of an article if you decide that you didn't really
want to read it.  You can jump from the reading portion back to either
page you came from or the NEXT page.
.sp
For replying and posting followups, you will be thrown into an editor
to create the reply or article.
The article will be included in the file you are editing, marked with
"> "'s for excerpting in your reply or followup.  After you exit the
editor, you are prompted to make sure you still want to post or reply,
so you can abort.
.sp
For followups, your article is appended to "author_copy" for future
reference.
.sp
Header lines for the mailer / news poster are present in the file
you are editing to allow you to modify them.  Remember to leave a blank
line between the header lines and your text.  It may be OK if you
don't, but why tempt fate.
.sp
The editor is determined by your EDITOR variable, as for
.I postnews.
If EDITOR is not set, you get
.I vi,
or the default determined at your site.
.sp
.ce 1
Reading menu:
.sp
.nf
         n - next article, if any
         q - quit reading articles, if any more to read
         Q - quit reading, and turn to next page of articles
         r - rewind article to beginning
  <return> - next line
         / - search for a pattern in the article
         m - send mail to author of article
         f - post followup to article
         s - save article in a file
         p - send article to the printer
         ? - see this help menu
	 z - toggle rotation flag
	 h - toggle header suppression flag

 anything else to continue normal reading
.fi
.sp
If you don't like the choice of command keys, you
may change them (default choices - basic control in article
reader is ala "more" of course, the "j" and "k" on the page presentation
are "vi" convention, other page commands are somewhat "readnews" compatible).
If you have a file named
.B .vnkey
in your home directory this file will be read in order to obtain keystroke
translation.  The format is simple:
.sp
Each line begins with R or P indicating translation for the reader interaction,
or the page interaction (r and p accepted also).  Following the R or P is
a character, followed by an "=", followed by another character.  The character
on the left hand side of the equals sign is what you wish to input, and the
character on the right hand side of the equals sign is what you wish to
translate it to.  No embedded spaces.
Lines not beginining with the proper characters are simply
ignored, as are characters following the translated character.  Eg:
.sp
.in +5
Pd=j
.br
Pu=k
.in -5
.sp
uses "u" and "d" instead of "j" and "k" on the page layout (presumably,
you are also going to translate something else to "u" and "d" for the
unsubscribe and digest commands).  If you translate keys, it is up to you
to see that all commands can still be reached, and that former command keys
which are no longer used are mapped to something meaningless.  In particular,
you are going to have difficulties if you make it impossible to input "q".  The
help menus will show the "new" keys, and bad mappings should show up as
multiple definitions for the same key, or alternate mappings not showing
up on the help menu.
.sp
Mapping the "=" key via "==" works.  Any keys not mentioned in the file
are translated to themselves.
.sp
Control keys are given as DECIMAL numbers with no backslashes or anything.
The decimal number is the ASCII code for the character, eg:
.sp
.in +5
P24=12
.br
P12=?
.in -5
uses "control-x" for the "control-l (formfeed)" refresh key, and maps the
control-l to a "?".  BTW, mapping all undefined keys to "?" will mean that you
automatically get the help display for any illegal key, should you wish for
such a thing.  The LAST one mapped will determine what key is given in
the "? for help" lines, and the help display itself.
Remembering that control-A through
control-Z are ASCII codes 1 through 26 and delete = 127 may keep you from
having to consult an ASCII table.  Remember also that some controls, such
as control- C, Z, S or Q may be caught by the operating system for signal
generation or terminal control, and are thus unavailable.
.sp
Because of arrow keys and the ability to prefix commands with counts,
numeric characters and the escape key may not be used for page commands.
Attempts to use them will simply do nothing.
.sp
Control keys are not available for the reader, except for newline,
backspace, and tab.  The reason controls are filtered here has to do
with nasty problems involving terminal mode switches on some systems,
specifically a UTS frontend early versions were being used on.
.sp
In either interaction, "return" and "linefeed" are mapped to the "newline"
character at a level below the translation.  If you don't know the
ASCII for the "newline" char, it is recommended that you map both
ASCII 10 and 13 if you wish to map "return" to something.
.SH FILES
.TP 24
/usr/tmp/*
One temporary file created by
.I tmpnam
(3), and immediately unlinked,
remains open in update mode for duration of session.
Disk space freed by system close of file descriptor at exit.
Can be large, as this file contains the "page" displays.
Temporary files also created by
.I tmpnam
(3) for mailing replies, posting followups and creating digest "articles".
.TP 24
(login directory)/.newsrc
news status file.  Updated following session.  See NEWSRC environment variable.
.TP 24
(login directory)/author_copy
A copy of all articles posted using the followup command will be appended
to this file in /bin/mail format.  See CCFILE environment variable.
.TP 24
(login directory)/.vnkey
Keystroke mapping file for changing command characters.
.TP 24
(login directory)/*.vnXXXXXX
One temporary file created by
.I tmpnam
(3) while updating the .newsrc file.  If the update fails, you are informed,
and this file
may be used to recover the last update.  Unlinked following successful update.
.TP 24
(spool directory)/*
spooling directories containing articles.
.TP 24
/usr/lib/news/active
active newsgroup list.
.SH "ENVIRONMENT VARIABLES"
.TP 24
PS1
used to present prompt string for command on unix escape.
defaults to "$ "
.TP 24
EDITOR
editor used for mailing replies and posting followups.
defaults to "ed".
.TP 24
POSTER
posting program for followups.  defaults to "inews -h".
.TP 24
MAILER
used when mailing replies.  defaults to "sendmail -t".
.TP 24
PRINTER
program used with the print commands for sending articles to
the printer.  defaults to "lpr".
.TP 24
NEWSRC
if set, can be used to override the choice of ".newsrc" as the
name for the status file.  Name will still be used relative to
the login directory, unless it begins with "/".
.TP 24
CCFILE
if set, overrides the choice of "author_copy" as the name of the
file to CC all articles posted with the followup command.  Name
will still be used relative to the login directory, unless it begins
with "/".
.TP 24
VNKEY
if set, overrides the choice of ".vnkey" as the name of the
file to map keys from.  Name
will still be used relative to the login directory, unless it begins
with "/".
.SH DIAGNOSTICS
user error messages.  self explanatory.
.SH AUTHOR
R. L. McQueer
.SH BUGS
Note that
.I readnews
will rearrange the order of
.B .newsrc.
If you
interleave use of it with
.I vn,
order selection gets hosed.
.sp
If you've really taken advantage of the ability of readnews to skip
articles in the middle of the spooling numbers, be warned that
.I vn
doesn't have it, and will
assume you've read the articles in the middle.
.sp
If the
.B .newsrc
file indicates that you've read articles in a newsgroup with a higher
number than the current spooling number for that newsgroup,
.I vn
will show you the entire newsgroup.  This is intended for recovery in
cases where article spooling has been reset, or to avoid missing articles
because you just changed machines and didn't bother to edit your
.B .newsrc
file.  Rather than miss stuff, you'll see some old stuff again.
.sp
Sometimes a "break" during reading an article will not only halt the
article but suppress the prompt.  A command character will work anyway.
.sp
If a prompt to be displayed on the dialogue line
contains non-printing sequences, stuff on the
line may not get erased when you are prompted, because
.I vn
thinks the string is long enough to overprint its current contents.
This usually comes up when you have escape sequences in your UNIX
prompt, and do a "!" command.
The "overprint" check is made to save a clear-line sequence (kludged in
by overprinting to the end with blanks if the terminal doesn't
have one - annoying at 1200 baud).
.sp
Output during the reading phase which was suppressed by backgrounding
.I vn
does not get started by foregrounding it again without doing a
control-z and a second foreground (it doesn't figure out its background /
foreground status on each output - only on startup and while handling
the SIGTSTP signal).  Actually, this results in a method for having
.I vn
do its reading phase silently in the foreground without redirecting
output, should such a thing be desired.
.sp
Very many -w or -t options cause SLOW reading phases.  It is reccomended
that these be used only when reading a few specific groups.
.sp
Digest extraction will split a single article into several if it contains
embedded ---- lines, the normal separator between articles in digests.
They will all have identical titles.
Digest extraction may not work with human built digests which don't
use the expected syntax for joining articles.  mod.computers.ibm-pc
and mod.computers.mac were used as models for the feature.
.sp
The data given by the % command represents the difference between the
last article number you've updated to in a newsgroup and the high
article number.  This may be significantly greater than the number of
actual articles for a newsgroup you haven't been reading, and for
newsgroups that have had a lot of articles filtered out of them using
the -w and -t options.  The numbers given for menu selection in the
 % command are the order numbers from the .newsrc, and have gaps for
unsubscribed newsgroups.
.sp
The key mapping capability doesn't handle function keys.  Because of the
use of controls as commands, terminals whose arrow keys echo something
other than a sequence beginning with escape can't use arrow keys.  For
these terminals, a warning message is printed during the reading phase.
