;;
;; MCALL - macros for assembly linkage
;; from Dr. Dobbs, #84, p100.
;;
;    with further macros--see after "******"
;    with new bend & bexit macros 1/20/84

@argdef	macro	argnames
  @nargs=0
  ifnb<argnames>
    irp	dummy,<argnames>
      @nargs=@nargs+2
    endm
    @i=@nargs+2
    irp arg,<argnames>
      arg&&@=@i
      ifndef arg
        arg  equ  [bp + arg&&@]
      endif
      @i=@i-2
    endm
endif
endm

@err	macro	msg
  if1
    %out msg
  endif
endm

@check	macro	extra,macname
  ifnb<extra>
    @err <you forgot angle brackets in macname macro>
  endif
endm

bentry	macro	func,argnames,mistake
  @nlv=0
  @nsr=0
  @savefl=0
  irp flag,<@ax,@bx,@cx,@dx,@si,@di,@ds,@ss,@es,@flags>
    flag=0
  endm
  ifb<func>
    @err  <missing function name on bentry macro>
  else
    @err  <!>!>!>Begin func>
  endif
  @check mistake,bentry
  @argdef <argnames>
func	proc
	push	bp
	mov	bp, sp
endm

auto	macro	vars,mistake
  if @savefl
    @err <***ERROR*** must not save before auto>
  endif
  @check mistake,auto
  irp var,<vars>
    var&&@=-(@nlv+2)
    ifndef var
      var equ [bp + var&&@]
    endif
    @nlv=@nlv+2
  endm
	sub	sp, @nlv
endm

@pop	macro	reg
  if @&reg
    ifidn<reg>,<flags>
	popf
    else
	pop	reg
    endif
  endif
endm

;bend	macro	func
;  ifb<func>
;    @err <Missing name on bend macro>
;  endif
;  @err <!<!<!<End func>
;func&_end:
;  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
;	@pop	reg
;  endm
;  if @nlv
;	add	sp, @nlv
;  endif
;	pop	bp
;	ret	@nargs
;func	endp
;endm

			; New macro 1/20/84 PLD.
bexit	macro
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
endm

			; New bend macro 1/20/84 PLD.
bend	macro	func
  ifb<func>
    @err <Missing name on bend macro>
  endif
  @err <!<!<!<End func>
func&_end:		;; bexit repeated here:
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
func endp
endm

@save	macro	r1,r2
ifidn<r1>,<r2>
  @&r1=1
  @found=1
endif
endm

save	macro	regs,mistake
  @savfl=1
  @check mistake,save
  irp reg,<regs>
    @found=0
    irp regname,<ax,bx,cx,dx,si,di,ds,ss,es,flags>
      @save regname,reg
    endm
    ife @found
      @err <***ERROR*** 'reg': Unknown register name in save>
    endif
  endm
  irp reg,<ax,bx,cx,dx,si,di,ds,ss,es,flags>
    if @&&reg
      ifidn<flags>,<reg>
	pushf
      else
	push	reg
      endif
    endif
  endm
endm

bcall	macro	func,args,mistake
  @check mistake,func
  ifnb<args>
    irp arg,<args>
	push	arg
    endm
  endif
	call	func
endm

;**********  New macros (not from Dr. Dobb's Journal):

@fargdef	macro	argnames
  @nargs=0
  ifnb<argnames>
    irp	dummy,<argnames>
      @nargs=@nargs+4
    endm
    @i=@nargs+2
    irp arg,<argnames>
      arg&&@=@i
      ifndef arg
        arg  equ  dword ptr [bp + arg&&@]
      endif
      @i=@i-4
    endm
endif
endm

fentry	macro	func,argnames,mistake
  @nlv=0
  @nsr=0
  @savefl=0
  irp flag,<@ax,@bx,@cx,@dx,@si,@di,@ds,@ss,@es,@flags>
    flag=0
  endm
  ifb<func>
    @err  <missing function name on fentry macro>
  else
    @err  <!>!>!>Begin func>
  endif
  @check mistake,fentry
  @fargdef <argnames>
func	proc	far
	public	func
	assume	ds:nothing, es:nothing, ss:nothing
	push	bp
	mov	bp, sp
endm

fexit	macro		;; bexit repeated here:
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
 endm

fend	macro	func		;; bend repeated here:
  ifb<func>
    @err <Missing name on bend macro>
  endif
  @err <!<!<!<End func>
func&_end:		;; bexit repeated here:
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
func endp
 endm

dos_error	macro	fd
	les	bx,fd
	assume	es:nothing
	bcall	sys_err,<es:[bx],ax>
 endm

get_handle	macro	fd	;; Get file handle from
	les	bx,fd		;;   ST file descriptor.
	assume	es:nothing
	call	g_handle
 endm

put_handle	macro	fd	;; Given ST file descriptor
	les	bx,fd		;;   store the handle in AX into
	assume	es:nothing
	call	p_handle	;;   array "handle".
 endm
