page 66,96	; For 8 inches, 12 columns/inch.
;*******************************************************
;
;##			CMT1.ASM
;
;	Bottom-level utility routines used by Software Tools
;	    on MSDOS 2.x.
;	    5/4/84 PLD
;
; Copyright (c) 1984 by Carousel MicroTools Inc., El Cerrito, CA, USA

;if1	; Doesn't work.		
  include mcall.asm
  include libdefs.asm
;  endif	; Matches if1.

SCRATCHSIZE equ 300	; Must be at least:
			;   MAXNAME for doscd, isdir,
			;	dosopn, doscre, and dosulk;
			;   MAXNAME*2 for dosmov;
			;   MAXLINE (?) for outszz & outlzz;
;			;   43+MAXNAME for dosfnd.



utildt segment word public	; Avoid class 'data'.
    outoff dw 0		; Scratch space (to hold IP = 0)
    outseg dw 0		; Where WE store original ES.
			; Remains 0 if can't discover it.

    psp_seg dw 0	; Public copy of outseg
    public psp_seg

    scratch db SCRATCHSIZE dup (?)	;Scratch space for stuff below.
    utildt ends

sframe	struc
savebp	dw	?
retu	dd	?
toparg	dd	?
penarg	dd	?
fstarg	dd	?
sframe	ends

	extrn	CESXQQ:word	; where ENTXQQ stores original ES
				;   before moving DATA & other segments

util6	segment	byte 'code'
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

start equ this byte
    db "Copyright (c) 1984 Carousel MicroTools, Inc.,"
    db " El Cerrito, CA, USA",cr,lf
    db "Version 2.00 5/4/84 PLD",cr,lf

;*****************************
;
;##   BDOSZD (Should be replaced, but this is a quick
;	interface to the "GET DISK" function.)

bdoszd	proc	far
	public	bdoszd
	assume cs:util6, ds:nothing, es:nothing, ss:nothing

	push	bp
	mov	bp,sp
	les	bx,[bp].toparg
	assume	es:nothing
	mov	dx,es:[bx]
	les	bx,[bp].penarg
	assume es:nothing
	mov	ah,es:[bx]
	int	21h
	mov	ah,0
	pop	bp
	ret	8

bdoszd	endp

;***********************************
;
;##   INITZZ

initzz	proc	far
	public	initzz
	assume cs:util6, ss:nothing, es:nothing, ds:nothing

	push	bp
	mov	bp,sp

			; Set ES:DI to physical address of start of
			;   this code module:
	mov di,cs
	mov es,di
	assume es:util6
	mov di,offset start
	call norm_es_di
	assume es:nothing
			; Check paragraph alignment:
	cmp di,0	; Bad trouble if this module doesn't
	jne near ptr exit;   immediately follow PSP.

	mov ax,es	; Adjust ES:DI to point to PSP.
	sub ax,10h
	mov es,ax
	assume es:nothing
	call norm_es_di
	assume es:nothing

			; Check it's really PSP:
	cmp word ptr es:[di],020CDh	; INT 20h expected
	jne near ptr exit ; Try to quit (hope this is DOS 2+)

	mov cx,es	; Save PSP paragraph # in outseg & psp_seg
	mov	bx,seg outseg
	mov	es,bx
	assume	es:utildt
	mov	outseg,cx
	mov	psp_seg,cx

	pop	bp
	ret

initzz	endp

;******************************
;
;## exit -- unconditionally abort Fortran program
;
;    call exit (cod)	# No return.
;	integer*1 cod	# To be passed to invoking process
;			#   (0 = no error).

fentry exit,<cod>
	assume cs:util6, ss:nothing, es:nothing, ds:nothing

				; Check DOS version.
	mov ah,ms_version
	int 21h
	cmp al,2
	jb old_exit

				; DOS 2+
	les bx,cod
	assume es:nothing
	mov al,es:[bx]
	mov ah,ms_terminate
	int 21h

old_exit:			; DOS 1.x
	assume ds:nothing, es:nothing
	mov bx,seg outseg	; First see whether outseg
	mov ds,bx		;   contains a valid address.
	assume ds:utildt
	cmp outseg,0
	jne have_out_addr

				; Running out of options:
				;   try CESXQQ, hope it wasn't overwritten.
	mov bx,seg cesxqq
	mov es,bx
	assume es:nothing
	mov bx,offset cesxqq
	mov ax,[bx]
	mov outseg,ax 	; Set up doubleword address of start of PSP

have_out_addr:
	mov outoff,0		; Jump out via vector set up by initzz.
				;   or by code immediately above.
	jmp dword ptr outoff

	fend exit

;**********************************
;
;##   DOSSEL:  Select new default disk drive
;
;	stat = dossel(dr)
;	integer stat, dossel	# OK or ERR
;	character dr		# A or a, etc.

fentry dossel,<dr>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,dr
    assume es:nothing
    mov dl,es:[bx]
    cmp dl,'a'
    jb dossel_big
    cmp dl,'z'
    ja dossel_err
    sub dl,'a'-'A'	; Raise case.
dossel_big:

    sub dl,'A'		; 0 for A:, etc.
    mov ah,ms_seldisk
    int 21h

    cmp dl,al
    jae dossel_err

	mov ax,OK
	jmp short dossel_end

dossel_err:
    mov ax,ERR

    fend dossel

;****************************
;
;##   DOSCD:  Change current directory on current disk (?)
;
;	stat = doscd(dir)
;	integer*2 stat, doscd	# OK or ERR
;	character dir(ARB)	# Terminated by EOS.

fentry doscd,<dir>
    assume cs:util6, ds:nothing, ss:nothing, es:nothing
    save ds

    lds si,dir		; Pack dir name into scratch space.
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Save addr of packed dir name.
    cld
    mov cx,SCRATCHSIZE-1	; Prevent overflow.
doscd_loop:
	lodsw
	cmp ax,EOS
	je doscd_loop_done      
	stosb
	loop doscd_loop
    jmp short doscd_err		; Probable overflow.
doscd_loop_done:
    mov byte ptr es:[di],0
			; DS:DX --> scratch space
    mov ax,es
    mov ds,ax
    assume ds:utildt

    mov ah,ms_cd
    int 21h

    jc doscd_err

	mov ax,OK
	jmp short doscd_end

doscd_err:
    mov ax,ERR

    fend doscd

;******************************
;
;##   DOSCRE:  have DOS create a file
;
;	stat = doscre(nam, attr, hndl)
;	integer*2 stat, doscre, hndl, attr
;	character nam(ARB)	# terminated by EOS; unpacked

fentry doscre,<nam,attr,hndl>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds si,nam			; Pack filename into scratch space.
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Save addr of packed filename.
    cld
    mov cx,SCRATCHSIZE-1	; Prevent overflow.
doscre_loop:
	lodsw
	cmp ax,EOS
	je doscre_loop_done      
	stosb
	loop doscre_loop
    jmp short doscre_err	; Probable overflow.
doscre_loop_done:
    mov byte ptr es:[di],0
			; DS:DX --> scratch space
    mov ax,es
    mov ds,ax
    assume ds:utildt

    les bx,attr
    assume es:nothing
    mov cx,es:[bx]

    mov ah,ms_2_create
    int 21h

    jc doscre_err

			; Case of no error
	les bx,hndl
	assume es:nothing
	mov es:[bx],ax
	mov ax,OK
	jmp short doscre_end

			; Case of error
doscre_err:
	mov ax,ERR

    fend doscre

;******************************
;
;##   DOSOPN:  have DOS open a file
;
;	stat = dosopn(nam, acc, hndl)
;	integer*2 stat, dosopn, hndl
;	integer*1 acc
;	character nam(ARB)	# terminated by EOS; unpacked

fentry dosopn,<nam,acc,hndl>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds si,nam			; Pack filename into scratch space.
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Save addr of packed filename.
    cld
    mov cx,SCRATCHSIZE-1	; Prevent overflow.
dosopn_loop:
	lodsw
	cmp ax,EOS
	je dosopn_loop_done      
	stosb
	loop dosopn_loop
    jmp short dosopn_err	; Probable overflow.
dosopn_loop_done:
    mov byte ptr es:[di],0
			; DS:DX --> scratch space
    mov ax,es
    mov ds,ax
    assume ds:utildt

    les bx,acc
    assume es:nothing
    mov al,es:[bx]

    mov ah,ms_2_open
    int 21h

    jc dosopn_err

			; Case of no error
	les bx,hndl
	assume es:nothing
	mov es:[bx],ax
	mov ax,OK
	jmp short dosopn_end

			; Case of error
dosopn_err:
	mov ax,ERR

    fend dosopn

;*****************************
;
;##   DOSCLS:  have DOS close a handle
;
;	stat = doscls(hndl)
;	integer*2 stat, doscls, hndl

fentry doscls,<hndl>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,hndl
    assume es:nothing
    mov bx,es:[bx]
    mov ah,ms_2_close
    int 21h

    mov ax,ERR
    jc doscls_end
    mov ax,OK

    fend doscls

;***************************
;
;##   DOSRD:  call DOS to read data
;
;	stat = dosrd(hndl,addr,count,result)
;	integer*2 stat, dosrd, hndl, count, result
;	integer*4 addr

fentry dosrd,<hndl,addr,count,result>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    les bx,count
    assume es:nothing
    mov cx,es:[bx]

    les bx,addr
    assume es:nothing
    lds dx,dword ptr es:[bx]
    assume ds:nothing

    les bx,hndl
    assume es:nothing
    mov bx,es:[bx]

    mov ah,ms_getch
    int 21h

    jc dosrd_err

			; Case of no error:
	les bx,result
	assume es:nothing
	mov es:[bx],ax	; # of characters returned

	cmp ax,0
	je dosrd_eof

				; Case of not EOF:
	    mov ax,OK
	    jmp short dosrd_end

				; Case of EOF
dosrd_eof:
	    mov ax,EOF
	    jmp short dosrd_end

			; Case of error:
dosrd_err:
	mov ax,ERR

    fend dosrd

;***************************
;
;##   DOSWRT:  call DOS to write data
;
;	stat = doswrt(hndl,addr,count)
;	integer*2 stat, doswrt, hndl, count
;	integer*4 addr

fentry doswrt,<hndl,addr,count>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    les bx,count
    assume es:nothing
    mov cx,es:[bx]

    les bx,addr
    assume es:nothing
    mov dx,es:[bx]
    inc bx
    inc bx
    mov ds,es:[bx]
    assume ds:nothing

    les bx,hndl
    assume es:nothing
    mov bx,es:[bx]

    mov ah,ms_putch
    int 21h

    jc doswrt_err
    cmp ax,cx		; Number read must match number requested.
    jne doswrt_err

			; Case of no error:
	mov ax,OK
	jmp short doswrt_end

			; Case of error:
doswrt_err:
	mov ax,ERR

    fend doswrt

;******************************
;
;##   DOSULK:  have DOS delete ("unlink") a file
;
;	stat = dosulk(nam)	# Returns OK, ERR or NOT_FOUND.
;	integer*2 stat, dosulk
;	character nam(ARB)	# terminated by EOS; unpacked

fentry dosulk,<nam>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds si,nam			; Pack filename into scratch space.
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Save addr of packed filename.
    cld
    mov cx,SCRATCHSIZE-1	; Prevent overflow.
dosulk_loop:
	lodsw
	cmp ax,EOS
	je dosulk_loop_done      
	stosb
	loop dosulk_loop
    jmp short dosulk_err	; Probable overflow.
dosulk_loop_done:
    mov byte ptr es:[di],0
			; DS:DX --> scratch space
    mov ax,es
    mov ds,ax
    assume ds:utildt

    mov ah,ms_unlink
    int 21h

    jc dosulk_err

			; Case of no error
	mov ax,OK
	jmp short dosulk_end

			; Case of error
dosulk_err:
	cmp ax,ms_file_not_found
	jne dosulk_other_err
	mov ax,NOT_FOUND
	jmp short dosulk_end

dosulk_other_err:
	mov ax,ERR

    fend dosulk

;*****************************
;
;##   LSEEK:  Call DOS Lseek function
;
;	stat = lseek (handle, method, ofset, result)
;	integer*2 stat, lseek, handle, method
;	integer*4 ofset, result
;
;	method = 0 if from beginning of file;
;		 1 if from current file position;
;		 2 if from end of file.

fentry lseek,<hndl,method,ofset,result>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,ofset
    assume es:nothing
    mov dx,es:[bx]	; Put offset into CX:DX.
    inc bx
    inc bx
    mov cx,es:[bx]

    les bx,method
    assume es:nothing
    mov al,es:[bx]	; Method into AL

    les bx,hndl
    assume es:nothing
    mov bx,es:[bx]	; Handle into BX

    mov ah,ms_lseek
    int 21h

    jc lseek_err

			; Case of no error:
	les bx,result
	assume es:nothing
	mov es:[bx],ax
	inc bx
	inc bx
	mov es:[bx],dx
	mov ax,OK
	jmp short lseek_end

			; Case of error:
lseek_err:
	mov ax,ERR

    fend lseek

;********************************
;
;##   DOSGDR:  Ask DOS for path to current directory.
;
;	stat = dosgdr(drive, path)	# Stat returned as OK or ERR.
;	integer*2 stat, dosgdr, drive	# Drive is 0 = default, 1=A:, etc.
;	character path(ARB)		# unpacked.

fentry dosgdr,<drive,path>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    les bx,drive
    assume es:nothing
    mov dl,es:[bx]

    mov si,seg scratch
    mov ds,si
    assume ds:utildt
    lea si,scratch

    mov ah,ms_get_dir
    int 21h

    jc dosgdr_err

			; Case of no error:
	les di,path	; Unpack result into user's space.
	assume es:nothing
	cld
	mov ah,0
dosgdr_loop:
	    lodsb
	    cmp al,0
	    je dosgdr_done
	    stosw
	    jmp dosgdr_loop
dosgdr_done:
	mov word ptr es:[di],EOS
	mov ax,OK
	jmp short dosgdr_end

			; Case of error:
dosgdr_err:
	mov ax,ERR

    fend dosgdr

;********************************
;
;## isdir -- Tell whether a (possibly nonexistent)
;	disk file is a directory.  Fails unpredictably on root.
;
;	stat = isdir(file)	# NOT_FOUND if absent
;				#   else YES, NO, or ERR.
;	integer*2 stat, isdir
;	character file(ARB)	# Terminated by EOS.

fentry isdir,<file>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds si,file			; Pack filename into scratch space.
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Save addr of packed version.
    cld
    mov cx,SCRATCHSIZE-1	; Prevent overflow.
isdir_loop:
	lodsw
	cmp ax,EOS
	je isdir_loop_done      
	stosb
	loop isdir_loop
    jmp short isdir_err		; Probable overflow.
isdir_loop_done:
    mov byte ptr es:[di],0
			; DS:DX --> scratch space
    mov ax,es
    mov ds,ax
    assume ds:utildt

    mov ah,ms_chmod
    mov al,chmod_get
    int 21h

    jc isdir_maybe_err

	test cx,DIR_ATTR
	jz isdir_no

	    mov ax,YES
	    jmp short isdir_end

isdir_no:
	    mov ax,NO
	    jmp short isdir_end

isdir_maybe_err:
    cmp ax,ms_file_not_found
    je isdir_not_found
    cmp ax,ms_path_not_found
    je isdir_not_found
 
isdir_err:
    mov ax,ERR
    jmp short isdir_end

isdir_not_found:
    mov ax,NOT_FOUND

    fend isdir

;********************************
;
;## giowrd -- Ask DOS what kind of device a handle is.
;
;	stat = giowrd(hndl, dev, bin, iword)	# Returns OK or ERR
;	integer stat, giowrd, hndl
;	integer*2 dev	# Returns DISK, CONSOLE, CONSOLE_IN, 
;			#   CONSOLE_OUT, NULLDEV, or OTHER_DEV.
;	integer*2 bin	# Returns YES (if binary mode) or NO.
;	integer*2 iword # Returns whole word from IOCTL function.

fentry giowrd,<hndl,dev,bin,iword>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,hndl
    assume es:nothing
    mov bx,es:[bx]
    mov ah,ms_ioctl
    mov al,ioctl_g_info
    int 21h

    jc giowrd_err

        les bx,iword
	assume es:nothing
	mov es:[bx],dx

			; Case of no error:  test the bit.
	test dx,ISDEV_BIT
	jz giowrd_not_dev

			; Yes, this is a device.
	    test dx,ISCOT_BIT
	    jz giowrd_not_cot

			; Is CONSOLE_OUT, perhaps also CONSOLE_IN.
		test dx,ISCIN_BIT
		jz giowrd_cot
		mov si,CONSOLE	; Both CONSOLE_OUT and CONSOLE_IN.
		jmp short giowrd_gbin
giowrd_cot:
		mov si,CONSOLE_OUT	; Is CONSOLE_OUT but not
		jmp short giowrd_gbin	;   CONSOLE_IN.

giowrd_not_cot:
	    test dx,ISCIN_BIT
	    jz giowrd_dev
	    mov si,CONSOLE_IN		; Is CONSOLE_IN but not
	    jmp short giowrd_gbin	;   CONSOLE_OUT.

giowrd_dev:		; Some non-console device.
	    test dx,ISNUL_BIT
	    jz giowrd_other_dev
	    mov si,NULLDEV
	    jmp short giowrd_gbin

giowrd_other_dev:
	    mov si,OTHER_DEV

giowrd_gbin:
	mov di,NO
	test dx,BIN_BIT
	jz giowrd_done
	mov di,YES
	jmp short giowrd_done
	
			; No, not a device, hence a DISK file.
giowrd_not_dev:
	    mov si,DISK
	    mov di,YES

giowrd_done:
    les bx,dev
    assume es:nothing
    mov es:[bx],si
    les bx,bin
    assume es:nothing
    mov es:[bx],di
    mov ax,OK
    jmp short giowrd_end

			; Case of error.
giowrd_err:
	mov ax,ERR

    fend giowrd

;*************************************
;
;## siowrd -- Set a handle's binary state if it's a device.
;
;	stat = siowrd(hndl, state, havwrd, iword) # Returns OK or ERR.
;	integer stat, siowrd, hndl
;	integer state		# State is YES to turn binary on.  Anything
;				#   else turns if off.
;	integer havwrd		# YES means iword is valid.
;	integer*2 iword		# Previous word from IOCTL on this hndl.

fentry siowrd,<hndl,state,havwrd,iword>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,hndl
    assume es:nothing
    mov bx,es:[bx]

    les si,havwrd
    assume es:nothing
    cmp word ptr es:[si],YES
    jne siowrd_ask

    les si,iword
    assume es:nothing
    mov dx,es:[si]
    jmp short siowrd_know
    
siowrd_ask:
    mov ah,ms_ioctl
    mov al,ioctl_g_info
    int 21h

    jc siowrd_err

			; Have correctly got current info in DX.
siowrd_know:
	test dx,isdev_bit
	jz siowrd_ok	; Do nothing if it's not a device.

	les si,state
	assume es:nothing
	cmp word ptr es:[si],YES
	jne siowrd_off

			; Turn binary on
	test dx,bin_bit
	jnz siowrd_ok	; Already binary, so quit.
	or dx,bin_bit
	jmp short siowrd_set

			; Turn binary off
siowrd_off:
	test dx,bin_bit
	jz siowrd_ok	; Already non-binary, so quit.
	and dx,not bin_bit

siowrd_set:
	xor dh,dh
	mov ah,ms_ioctl
	mov al,ioctl_s_info
	int 21h
	jc siowrd_err

siowrd_ok:
	    mov ax,OK
	    jmp short siowrd_end

siowrd_err:
	mov ax,ERR

    fend siowrd

;;********************************
;;
;;##   DOSDEV:  Ask DOS what kind of device a handle is.
;;
;;	stat = dosdev(hndl)	# Returns DISK, CONSOLE, OTHER_DEV, or ERR
;;	integer stat, dosdev, hndl
;
;fentry dosdev,<hndl>
;    assume cs:util6, ds:nothing, es:nothing, ss:nothing
;
;    les bx,hndl
;    assume es:nothing
;    mov bx,es:[bx]
;    mov ah,ms_ioctl
;    mov al,ioctl_g_info
;    int 21h
;
;    jc dosdev_err
;
;			; Case of no error:  test the bit.
;	test dx,ISDEV_BIT
;	jz not_dev
;
;			; Yes, this is a device.
;	    test dx,ISCOT_BIT+ISCIN_BIT
;	    jz not_con
;
;			; Is console.
;		mov ax,CONSOLE
;		jmp short dosdev_end
;
;			; Is device, but not console.
;not_con:
;		mov ax,OTHER_DEV
;		jmp short dosdev_end
;
;			; No, not a device.
;not_dev:
;	    mov ax,DISK
;	    jmp short dosdev_end
;
;			; Case of error.
;dosdev_err:
;	mov ax,ERR
;
;    fend dosdev

;********************************
;
;## iscot -- Ask DOS whether this device is console output.
;
;	stat = iscot(hndl)	# Returns YES, NO, or ERR.
;	integer stat, iscot, hndl

;fentry iscot,<hndl>
;    assume cs:util6, ds:nothing, es:nothing, ss:nothing
;
;    les bx,hndl
;    assume es:nothing
;    mov bx,es:[bx]
;    mov ah,ms_ioctl
;    mov al,ioctl_g_info
;    int 21h
;
;   jc iscot_err
;
;			; Case of no error:  test the bit.
;	test dx,ISDEV_BIT
;	jz not_cot
;
;			; Yes, this is a device.
;	    test dx,ISCOT_BIT
;	    jz not_cot
;
;			; Is console out.
;		mov ax,YES
;		jmp short iscot_end
;
;			; No, not console out.
;not_cot:
;	    mov ax,NO
;	    jmp short iscot_end
;
;			; Case of error.
;iscot_err:
;	mov ax,ERR
;
;    fend iscot

;**********************************
;
;##   DOSFND:  Find first file matching a given name.
;
;   stat = dosfnd(nm, attr, siz)
;	integer*2 stat, dosfnd, attr	# attr gets attribute byte
;	integer*4 siz			# true 32-bit file size
;	character nm(ARB)		# unpacked, null-terminated

;fentry dosfnd,<nm,attr,siz>
;    assume cs:util6, ds:nothing, es:nothing, ss:nothing
;    save ds
;
;    mov dx,seg scratch		; First set DTA to scratch space.
;    mov ds,dx
;    assume ds:utildt
;    lea dx,scratch
;    mov ah,ms_set_dta
;    int 21h
;
;			; Pack filename into scratch space,
;			;   after the space to be filled in by DOS.
;    mov di,ds
;    mov es,di
;    assume es:utildt
;    mov di,dx
;    add di,ff_struc_size
;    lds si,nm
;    assume ds:nothing
;    cld
;    mov cx,SCRATCHSIZE-ff_struc_size-2	; Prevent overflow.
;dosfnd_loop:
;	lodsw
;	cmp ax,EOS
;	je dosfnd_loop_done      
;	stosb
;	loop dosfnd_loop
;    jmp short dosfnd_err	; Probable overflow.
;dosfnd_loop_done:
;    mov byte ptr es:[di],0
;			; DS:DX --> packed filename
;    mov dx,es
;    mov ds,dx
;    assume ds:utildt
;    lea dx,scratch.ff_struc_size
;
;    mov cx,HIDDEN_ATTR+SYSTEM_ATTR
;
;    mov ah,ms_2_find_first
;    int 21h
;
;    jc dosfnd_err
;
;				; Case of no error:
;	mov al,scratch.ff_attr	;   Return attr
;	mov ah,0
;	les bx,attr
;	assume es:nothing
;	mov es:[bx],ax
;	lds ax,scratch.ff_size	;   Return siz
;	assume ds:nothing
;	les di,siz
;	assume es:nothing
;	stosw
;	mov es:[di],ds
;	mov ax,OK
;	jmp short dosfnd_end
;
;				; Case of error:
;dosfnd_err:
;	mov ax,ERR
;
;   fend dosfnd

;**************************
;
;## unpack_dd -- local routine to unpack a dd_struc for Fortran
;
;   Entry parameters:
;	DS:BX --> dd_struc
;	ES=DS
;
;	Preserves DS, ES, CS, SS, BP.  Restores IP on return.

unpack_dd proc near
	assume cs:util6, ds:nothing, es:nothing, ss:nothing

					; Unpack found name
	lea si,[bx].dd_reserve.ff_name
	lea di,[bx].dd_found_name
	mov cx,size dd_found_name
	cld
	mov ah,0
dosmat_unpack:
	    lodsb
	    cmp al,0
	    je dosmat_unpack_done
	    stosw
	    loop dosmat_unpack
dosmat_unpack_done:
	mov word ptr [di],EOS

				; Return size.
	lea si,[bx].dd_reserve.ff_size
	lea di,[bx].dd_found_size
	lodsw
	stosw
	lodsw
	stosw

				; Return attribute byte.
	mov al,byte ptr [bx].dd_reserve.ff_attr
	mov ah,0
	mov [bx].dd_found_attr,ax	

unpack_date_field macro field
    mov ax,dx
    and ax,mask ms_&field
    if ms_&field
	if ms_&field&-1
		mov cl,ms_&field
		shr ax,cl
	    else
		shr ax,1
	    endif
	endif
    endm

				; Unpack date.
	mov dx,[bx].dd_reserve.ff_date

	unpack_date_field year
	add ax,ms_base_year
	mov [bx].dd_found_date.getnow_year,ax

	unpack_date_field month
	mov [bx].dd_found_date.getnow_month,ax

	unpack_date_field day
	mov [bx].dd_found_date.getnow_day,ax

					; Unpack time.
	mov dx,[bx].dd_reserve.ff_time

	unpack_date_field hour
	mov [bx].dd_found_date.getnow_hour,ax

	unpack_date_field min
	mov [bx].dd_found_date.getnow_min,ax

	unpack_date_field sec
	shl ax,1
	mov [bx].dd_found_date.getnow_sec,ax

	xor ax,ax
	mov [bx].dd_found_date.getnow_msec,ax

	ret
	unpack_dd endp

;**********************************
;
;## dosmat -- Find first file matching a given name.
;
;   stat = dosmat(nm, attr, strc)
;	integer*2 stat, dosmat		# Returns YES, NO, or ERR.
;	integer*2 nm(ARB)		# unpacked, EOS-terminated.
;	integer*1 attr			# Attribute mask for search.
;	dd_struc strc			# For data concerning found file.

fentry dosmat,<nm,attr,strc>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds dx,strc		; Set DTA to DD_RESERVE field in strc
    assume ds:nothing
    if DD_RESERVE
	add dx,DD_RESERVE
	endif
    mov ah,ms_set_dta
    int 21h

			; Pack filename into scratch space.
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    lds si,nm
    assume ds:nothing
    cld
    mov cx,SCRATCHSIZE-2	; Prevent overflow.
dosmat_pack:
	lodsw
	cmp ax,EOS
	je dosmat_pack_done      
	stosb
	loop dosmat_pack
    jmp short dosmat_err	; Probable overflow.
dosmat_pack_done:
    mov byte ptr es:[di],0
			; DS:DX --> packed filename
    mov dx,es
    mov ds,dx
    assume ds:utildt
    lea dx,scratch

    les bx,attr
    assume es:nothing
    mov cl,es:[bx]
    mov ch,0

    mov ah,ms_2_find_first	; Do the search.
    int 21h

    jc dosmat_maybe_err

				; Case of no error:
	lds bx,strc
	assume ds:nothing
	mov ax,ds
	mov es,ax
	assume es:nothing	; Both ES:BX and DS:BX --> strc

	call unpack_dd		; Unpack dd_struc

	mov ax,YES		; A file was found.
	jmp short dosmat_end
	
				; Case of error return:
dosmat_maybe_err:
	assume ds:nothing, es:nothing

	cmp ax,ms_file_not_found
	jne dosmat_err
	mov ax,NO
	jmp short dosmat_end

dosmat_err:
	mov ax,ERR

    fend dosmat

;**********************************
;
;## dosmt2 -- Find another file matching a given name.
;
;   stat = dosmt2(strc)
;	integer*2 stat, dosmt2		# Returns YES, NO, or ERR.
;	dd_struc strc			# For data concerning found file.

fentry dosmt2,<strc>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds dx,strc		; Set DTA to DD_RESERVE field in strc
    assume ds:nothing
    if DD_RESERVE
	add dx,DD_RESERVE
	endif
    mov ah,ms_set_dta
    int 21h

    mov ah,ms_2_find_more	; Do the search.
    int 21h

    jc dosmt2_maybe_err

				; Case of no error:
	lds bx,strc
	assume ds:nothing
	mov ax,ds
	mov es,ax
	assume es:nothing	; Both ES:BX and DS:BX --> strc

	call unpack_dd		; Unpack dd_struc

	mov ax,YES		; A file was found.
	jmp short dosmt2_end
	
				; Case of error return:
dosmt2_maybe_err:
	assume ds:nothing, es:nothing

	cmp ax,ms_file_not_found
	jne dosmt2_err
	mov ax,NO
	jmp short dosmt2_end

dosmt2_err:
	mov ax,ERR

    fend dosmt2

;*******************************
;
;##   DOSMOV:  Move a directory entry to another path.
;
;	stat = dosmov(from, to)		# Returns OK or ERR
;	integer stat, dosmov
;	character from(ARB), to(ARB)	# Terminated with EOS.

fentry dosmov,<from,to>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds si,from			; Pack filename into scratch space.
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Start of packed "from".
    cld
    mov cx,SCRATCHSIZE-3	; Prevent overflow.
dosmov_loop:
	lodsw
	cmp ax,EOS
	je dosmov_loop_done      
	stosb
	loop dosmov_loop
    jmp short dosmov_err	; Probable overflow.
dosmov_loop_done:
    mov al,0
    stosb			; Now "from" is packed.
    dec cx

    lds si,to
    assume ds:nothing
    mov bx,di			; Save "to" address.
dosmov_to_loop:
	lodsw
	cmp ax,EOS
	je dosmov_to_loop_done
	stosb
	loop dosmov_to_loop
    jmp short dosmov_err	; Probable overflow.
dosmov_to_loop_done:
    mov byte ptr es:[di],0

    mov di,bx			; ES:DI --> packed "to"
    mov ax,es
    mov ds,ax
    assume ds:utildt		; DS:DX --> packed "from"

    mov ah,ms_move
    int 21h

    jc dosmov_err

	mov ax,OK
	jmp short dosmov_end

dosmov_err:
    mov ax,ERR

    fend dosmov

;***************************************
;
;## getdtz -- get change date & time of open handle
;
;	stat = getdtz(when, hndl)	# Returns OK or ERR.
;	integer*2 stat, getdtz, hndl
;	integer*2 when(7)		# In "getnow" format.

fentry getdtz,<when,hndl>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,hndl		; Get date.
    mov bx,es:[bx]
    mov ah,ms_file_date
    mov al,ms_file_date_get
    int 21h

    jc getdtz_err

	xchg ch,cl	; Put registers in correct order
	xchg dh,dl	;   (see IBM DOS 2.00 manual p. D-51)

	mov si,cx	; Preserve CX against being clobbered by
			;   unpack_date_field.

	les bx,when

					; Unpack date.
	unpack_date_field year
	add ax,ms_base_year
	mov es:[bx].getnow_year,ax

	unpack_date_field month
	mov es:[bx].getnow_month,ax

	unpack_date_field day
	mov es:[bx].getnow_day,ax

					; Unpack time.
	mov dx,si

	unpack_date_field hour
	mov es:[bx].getnow_hour,ax

	unpack_date_field min
	mov es:[bx].getnow_min,ax

	unpack_date_field sec
	shl ax,1
	mov es:[bx].getnow_sec,ax

	xor ax,ax
	mov es:[bx].getnow_msec,ax

	mov ax,OK
	jmp short getdtz_end

getdtz_err:
    mov ax,ERR

    fend getdtz

;***************************************
;
;## setdtz -- set change date & time of open handle
;
;	stat = setdtz(when, hndl)	# Returns OK or ERR.
;	integer*2 stat, setdtz, hndl
;	integer*2 when(7)		# In "getnow" format.

fentry setdtz,<when,hndl>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

pack_date_field macro field
    if ms_&field
	if ms_&field-1
		mov cl,ms_&field
		shl ax,cl
	    else
		shl ax,1
	    endif
	endif
    and ax,mask ms_&field
    endm

    les bx,when
    xor dx,dx		; Build packed date in DX.
    xor si,si		; Build packed time in SI.

				; Pack year
    mov ax,es:[bx].getnow_year
    cmp ax,1900
    jge setdtz_no_add_1900
        add ax,1900
setdtz_no_add_1900:
    sub ax,ms_base_year
    pack_date_field year
    or dx,ax

				; Pack month
    mov ax,es:[bx].getnow_month
    pack_date_field month
    or dx,ax

				; Pack day
    mov ax,es:[bx].getnow_day
    pack_date_field day
    or dx,ax

				; Pack hour
    mov ax,es:[bx].getnow_hour
    pack_date_field hour
    or si,ax

				; Pack minute
    mov ax,es:[bx].getnow_min
    pack_date_field min
    or si,ax

				; Pack second
    mov ax,es:[bx].getnow_sec
    shr ax,1
    pack_date_field sec
    or si,ax

			; Redate the file.
    les bx,hndl
    mov bx,es:[bx]
    mov cx,si
	xchg ch,cl	; Put registers in correct order
	xchg dh,dl	;   (see IBM DOS 2.00 manual p. D-51)
    mov ah,ms_file_date
    mov al,ms_file_date_set
    int 21h

    mov AX,OK
    jnc setdtz_end

	mov AX,ERR

    fend setdtz

;***************************************
;
;##   OUTSZZ:  Print emergency message to console.
;
;	call outszz(msg)
;	character msg(ARB)	; Terminated with EOS.

fentry outszz,<msg>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    lds si,msg
    assume ds:nothing
    mov di,seg scratch
    mov es,di
    assume es:utildt
    mov di,offset scratch
    mov dx,di			; Save starting point.
    mov cx,SCRATCHSIZE
    cld
outszz_loop:
	lodsw
	cmp ax,EOS
	je loop_done
	stosb
	loop outszz_loop	; Ignore excess portion of message.
loop_done:
    mov cx,di
    sub cx,dx			; CX now has message length,
				;   without EOS.
    mov ax,es
    mov ds,ax
    assume ds:utildt		; DS:DX --> packed message.

    mov bx,MS_ERROUT_HANDLE
    mov ah,ms_putch
    int 21h

    fend outszz		; no error checking.  Caller performs exit
			;    if needed.

;***************************************
;
;##   OUTLZZ:  Print emergency message to console, with
;	carriage return & line feed.
;
;	call outlzz(msg)
;	character msg(ARB)	; Terminated with EOS.

outlzz_data db CR,LF

fentry outlzz,<msg>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing
    save ds

    les bx,msg
    assume es:nothing
    push es
    push bx
    call outszz		; Above.
    assume es:nothing

    mov dx,seg outlzz_data
    mov ds,dx
    assume ds:util6
    lea dx,outlzz_data
    mov cx,2
    mov bx,MS_ERROUT_HANDLE
    mov ah,ms_putch
    int 21h

    fend outlzz

;***********************************
;
;##   MKARGZ

mkargz	proc	far
	public	mkargz
	assume cs:util6, ds:nothing, es:nothing, ss:nothing

	push	bp
	mov	bp,sp
	mov	dx,ds		; for safekeeping

	mov	ax,seg outseg
	mov	es,ax
	assume	es:utildt
	mov	ax,outseg
	mov	ds,ax	; now ds points at program segment prefix
	assume	ds:nothing
	mov	si,80h
	mov	ch,0
	mov	cl,[si]	; count
	inc	si
	les	di,[bp].toparg
	assume es:nothing
	mov	ah,0	; upper byte of result
	cld		; upward
	jcxz	l2	; Test for 0, which spoils loop.
l1:	lodsb
	stosw
	loop	l1
l2:
	mov	es:word ptr [di],eos

	mov	ds,dx	; restore before return
	assume	ds:nothing
	pop	bp
	ret	4

mkargz	endp

;****************************
;
;##   ADDR4:  returns doubleword address of its argument
;
;	iaddr = addr4(var)
;	integer*4 iaddr, addr4
;	??? var

fentry addr4,<var>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,var
    assume es:nothing

    fend addr4

;*****************************
;
;##   POKE
;
;	call poke (char, addr)
;	character char
;	integer*4 addr

fentry poke,<char,addr>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,char
    assume es:nothing
    mov al,es:[bx]
    les bx,addr
    assume es:nothing
    mov cx,es:[bx]
    inc bx
    inc bx
    mov es,es:[bx]
    assume es:nothing
    mov bx,cx
    mov es:[bx],al

    fend poke

;***************************
;
;##   POKE2 -- second version of poke (does index arithmetic)
;
;	call poke2 (char, ad4, n)
;	character char
;	integer*4 ad4	# such as returned by addr4
;	integer*2 n	# byte number, starts at 1

fentry poke2,<char,ad4,n>
    assume cs:util6

    les bx,n
    assume es:nothing
    mov si,es:[bx]
    dec si

    les bx,char
    assume es:nothing
    mov al,es:[bx]

    les bx,ad4
    assume es:nothing
    les bx,dword ptr es:[bx]
    assume es:nothing

    mov es:[bx+si],al

    fend poke2

;*****************************
;
;##   PEEK2 -- Special version of peek to do address arithmetic.
;
;	char = peek2(adr4, bytnum)
;	integer*2 char, peek2, bytnum	# bytnum starts from 1
;	integer*4 adr4		# as returned by addr4

fentry peek2,<adr4,bytnum>
    assume cs:util6, ds:nothing, es:nothing, ss:nothing

    les bx,bytnum
    assume es:nothing
    mov si,es:[bx]
    dec si

    les bx,adr4
    assume es:nothing
    les bx,dword ptr es:[bx]
    assume es:nothing

    mov al,es:[bx+si]
    mov ah,0

    fend peek2

;*****************************
;
;##   AND2

and2	proc	far
	public	and2
	assume	cs:util6, ds:nothing, ss:nothing, es:nothing

	push	bp
	mov	bp,sp
	
	les	bx,[bp].toparg
	assume es:nothing
	mov	ax,es:[bx]
	les	bx,[bp].penarg
	assume es:nothing
	and	ax,es:[bx]

	pop	bp
	ret	8

and2	endp

;**************************
;
;##   OR2

or2	proc	far
	public	or2
	assume	cs:util6, ds:nothing, ss:nothing, es:nothing

	push	bp
	mov	bp,sp
	
	les	bx,[bp].toparg
	assume es:nothing
	mov	ax,es:[bx]
	les	bx,[bp].penarg
	assume es:nothing
	or	ax,es:[bx]

	pop	bp
	ret	8

or2	endp

;*****************************
;
;##   PACK -- Pack a string from 1 char/word to 2 chars/word
;
;	call pack (uname, pname, pnamesize)
;		character uname(ARB)
;		integer*2 pname(pnamesize)
;		integer pnamesize
;	    packs the string in uname into pname, including the EOS.

;	fentry pack,<uname,pname,pnamesize>
;	assume	cs:util6, ds:nothing, es:nothing, ss:nothing
;	save	ds
;
;	les	bx,pnamesize
;	assume	es:nothing
;	mov	cx,es:[bx]
;	jcxz	pack_end	; CX == 0 spoils loop.
;	add	cx,cx
;	lds	si,uname
;	assume	ds:nothing
;	les	di,pname
;	assume	es:nothing
;	cld
;pack_loop:
;	lodsw
;	stosb
;	cmp	ax,EOS
;	je	pack_end
;	loop	pack_loop
;
;	fend	pack

;*******************************
;
;##   UNPACK -- unpack array of bytes into words, with 0 in upper byte.
;	Spaces should not overlap!
;
;	call unpack (pname, uname, nb)
;	integer*1 pname(ARB)
;	integer*2 uname(ARB)
;	integer nb		# number of original bytes.

;fentry unpack,<pname,uname,nb>
;   assume cs:util6, ds:nothing, es:nothing, ss:nothing
;    save ds
;
;    les bx,nb
;    assume es:nothing
;    mov cx,es:[bx]
;    jcxz unpack_end	; CX == 0 spoils loop.
;    les di,uname
;    assume es:nothing
;    lds si,pname
;    assume ds:nothing
;    cld
;    mov ah,0
;unpack_loop:
;	lodsb
;	stosw
;	loop unpack_loop
;
;   fend unpack

;***************************
;
;## PINTZZ - put a 16-bit integer into an array using character indexing
;    call pintzz (i,c,n)
;    integer i
;    array c taken as byte array
;    byte index into c, starts at 1.

pintzz	proc	far	; put int into array of characters
			; could be faster
	public	pintzz
	assume	cs:util6, ds:nothing, ss:nothing, es:nothing

	push	bp
	mov	bp,sp
	
	les	bx,[bp].fstarg	; i:  the integer to insert
	assume es:nothing
	mov	ax,es:[bx]
	les	bx,[bp].toparg	; n:  index where to insert it
	assume es:nothing
	mov	cx,es:[bx]
	dec	cx
	add	cx,cx		;     as word #	
	mov	di,cx
	les	bx,[bp].penarg	; c:  character array where to insert it
	assume es:nothing

	mov	es:[bx+di],al
	inc	di
	mov	es: byte ptr [bx+di],0
	inc	di
	mov	es:[bx+di],ah
	inc	di
	mov	es: byte ptr [bx+di],0

	pop	bp
	ret	12

pintzz	endp

;## MOVCIZ - stores a character into an array.
;    call movciz (c,b,i)
;    character c  #lsb of 16 bit int on msdos
;    array b      # taken as array of bytes
;    int i        # index into b, starts at 1

movciz	proc	far	; stores a char into an integer*2 array
	public	movciz
	assume	cs:util6, ds:nothing, es:nothing, ss:nothing

	push	bp
	mov	bp,sp

	les	bx,[bp].fstarg	; c:  the character
	assume es:nothing
	mov	al,es:[bx]
;	mov	ah,0

	les	bx,[bp].toparg	; i:  the index where to put it
	assume es:nothing
	mov	cx,es:[bx]
	dec	cx
;	add	cx,cx		;	as word #
	mov	di,cx

	les	bx,[bp].penarg	; b:  the array
	assume es:nothing
;	call	nmesbx		; assume the array fits within segment ES
	
	mov	es:[bx+di],al

	pop	bp
	ret	12
movciz	endp

;## MOVICZ - get character from a packed array
;    character function movicz (b,i)
;    array b     # taken as byte array
;    integer i   # index of desired character in byte array
; movicz extracts a byte and extends it to a character (16 bits on msdos)

movicz	proc	far	; get char from integer*2 array
	public	movicz
	assume	cs:util6, ds:nothing, es:nothing, ss:nothing

	push	bp
	mov	bp,sp

	les	bx,[bp].toparg	; i:  index
	assume es:nothing
	mov	cx,es:[bx]
	dec	cx
;	add	cx,cx		; 	as word number
	mov	di,cx
	
	les	bx,[bp].penarg	; b:  array
	assume es:nothing
	
	mov	al,es:[bx+di]
	mov	ah,0

	pop	bp
	ret	8
movicz	endp

;*********************************
;
;## getnow -- get current system date & time

daytime	struc
	year	dw	?
	month	dw	?
	day	dw	?
	hour	dw	?
	minute	dw	?
	second	dw	?
	frac	dw	?
daytime	ends

getnow	proc	far
	public	getnow
	assume	cs:util6, ss:nothing, es:nothing, ds:nothing

	push	bp
	mov	bp, sp
	mov	ah, 2ah
	int	21h
	les	bx, [bp].toparg
	assume es:nothing
	mov	es:[bx].year, cx
	mov	al, dh
	cbw
	mov	es:[bx].month, ax
	mov	al, dl
	cbw
	mov	es:[bx].day, ax
	mov	ah, 2ch
	int	21h
	les	bx, [bp].toparg
	assume es:nothing
	mov	al, ch
	cbw
	mov	es:[bx].hour, ax
	mov	al, cl
	cbw
	mov	es:[bx].minute, ax
	mov	al, dh
	cbw
	mov	es:[bx].second, ax
	mov	al, dl			; Hundredths of a second.
	mov bl,10
	mul bl
	mov	es:[bx].frac, ax	; Milliseconds.
	pop	bp
	ret	4

getnow	endp

;******************************
;
;## setdat -- set current system date & time

setdat	proc	far
	public	setdat
	assume	cs:util6, ds:nothing, es:nothing, ss:nothing

	push	bp
	mov	bp, sp
	les	bx, [bp].toparg
	assume es:nothing
	mov	cx, es:[bx].year
	mov	dh, byte ptr es:[bx].month
	mov	dl, byte ptr es:[bx].day
	mov	ah, 2bh
	int	21h
	les	bx, [bp].toparg
	assume es:nothing
	mov	ch, byte ptr es:[bx].hour
	mov	cl, byte ptr es:[bx].minute
	mov	dh, byte ptr es:[bx].second
	mov	ax, word ptr es:[bx].frac	; Milliseconds.
	mov dl,10
	div dl
	mov dl,al			; Centiseconds.
	mov	ah, 2dh
	int	21h
	pop	bp
	ret	4

setdat	endp

;**********************************
;
;## norm_es_di -- internal routine to normalize ES:DI
;
;	No arguments passed or registers altered except ES, DI.

bentry norm_es_di
    assume cs:util6, es:nothing, ss:nothing, ds:nothing
    save <ax,cx,flags>

	mov	ax,di	; extract top 12 bits of di
	rept 4
	    shr	ax,1
	    endm
	mov	cx,es
	add	ax,cx
	mov	es,ax		; paragraph number
	assume es:nothing
	and	di,1111b	; "Offset" within the paragraph

	bend norm_es_di

util6	ends

	end
