/* FILE file_stubs.c
 *
 * xplan - project planning tool
 * Copyright (C) 1992 Brian Gaubert, Mark M. Lacey, Richard Malingkas,
 * and Mike Marlow.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License (distributed with this program in the file
 * COPYING) for more details.
 * 
 * If you did not received a copy of the GNU General Public License
 * along with this program, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * Since this was a project for a one semester software engineering
 * course, the authors will not be offering support for the product
 * after its release.
 *
 * DESCRIPTION OF CONTENTS
 *
 * file_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `file.G'.
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include "db.h"
#include "xplan.h"

/* the project directory and filename */
char project_filename[256];

extern struct task_node *current_task;
extern load_save_flag;

/* FUNCTION applyButton_callback ****************************************

   PURPOSE

   Notify callback function for `applyButton'.

   INPUTS

   See XView manual.

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 30 Nov 1992
   Tester.... Mark M. Lacey, 30 Nov 1992

   MODIFICATIONS (most recent to least)

*/
void
applyButton_callback(Panel_item item, Event *event)
{
   int nrows;
   int count;
   struct task_node *current;
   Xv_notice notice;
   int retval;
   int status;
   int first;
   struct stat     s_buf;	/* points to file stat structure */

	file_filePopup_objects *ip = (file_filePopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

   strcpy(project_filename, (char *) xv_get(ip->directoryField,
					    PANEL_VALUE));
   strcat(project_filename, "/");
   strcat(project_filename, (char *)xv_get(ip->fileField,
					   PANEL_VALUE));

   if (load_save_flag == SAVE) {

      /* if the file already exists, make sure they want to */
      /* overwrite it */
      if (stat(project_filename, &s_buf) == 0) {
	 notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
			    NOTICE_MESSAGE_STRINGS, 
			    "File exists.  Overwrite?", 
			    NULL,
			    NOTICE_BUTTON_YES, "Yes",
			    NOTICE_BUTTON_NO, "No",
			    NOTICE_STATUS, &status,
			    XV_SHOW, TRUE,
			    NULL);
	 xv_destroy_safe(notice);
	 /* No, don't overwrite */
	 if (!status) {
	    return;
	 } else {
	    if (writefile_init(project_filename)==1) {
	       notice = xv_create(File_filePopup->filePopup, NOTICE,
				  NOTICE_MESSAGE_STRINGS, 
				  "Permission denied on file write", NULL,
				  NOTICE_BUTTON_YES, "Continue",
				  XV_SHOW, TRUE,
				  NULL);
	       xv_destroy_safe(notice);
	    }
	    xv_set(Main_mainWindow->mainWindow, FRAME_BUSY, FALSE, NULL);
	    xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_BUSY, FALSE,
		   NULL);
	    xv_set(File_filePopup->filePopup, FRAME_CMD_PUSHPIN_IN, FALSE,
		   NULL);
	    xv_set(File_filePopup->filePopup, XV_SHOW, FALSE, NULL);
	    return;
	 }
      } else {
	 /* if there is a problem writing, tell them about it */
	 if (writefile_init(project_filename)==1) {
	    notice = xv_create(File_filePopup->filePopup, NOTICE,
			       NOTICE_MESSAGE_STRINGS, 
			       "Permission denied on file write", NULL,
			       NOTICE_BUTTON_YES, "Continue",
			       XV_SHOW, TRUE,
			       NULL);
	    xv_destroy_safe(notice);
	 } 
	 xv_set(Main_mainWindow->mainWindow, FRAME_BUSY, FALSE, NULL);
	 xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_BUSY, FALSE,
		NULL);
	 xv_set(File_filePopup->filePopup, FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	 xv_set(File_filePopup->filePopup, XV_SHOW, FALSE, NULL);
	 return;
      }
   } else {
      destroy_task_list(get_main_task_list());
      retval = readfile(project_filename);
      if (retval==1) {
	 notice = xv_create(File_filePopup->filePopup, NOTICE,
			    NOTICE_MESSAGE_STRINGS, 
			    "File does not exist", NULL,
			    NOTICE_BUTTON_YES, "Continue",
			    XV_SHOW, TRUE,
			    NULL);
	 xv_destroy_safe(notice);
      } else if (retval == 2) {
	 notice = xv_create(File_filePopup->filePopup, NOTICE,
			    NOTICE_MESSAGE_STRINGS, 
			    "Error parsing input file", NULL,
			    NOTICE_BUTTON_YES, "Continue",
			    XV_SHOW, TRUE,
			    NULL);
	 xv_destroy_safe(notice);
      } else {
	 /* find the number of rows currently in the list, and */
	 /* delete them */
	 nrows = (int) xv_get(Main_mainWindow->taskList, PANEL_LIST_NROWS);
	 xv_set(Main_mainWindow->taskList, PANEL_LIST_DELETE_ROWS, 0, nrows,
		NULL);
	 
	 /* get the head of the task list, and set count to 0 */
	 current = get_main_task_list()->head;
	 count = 0;
	 
	 /* as long as their are still tasks */
	 while(current) {
	    /* add the task to the list */
	    xv_set(Main_mainWindow->taskList, PANEL_LIST_INSERT,
		   count, PANEL_LIST_STRING, count,
		   current->data->name, NULL);
	    
	    /* move to the next task, and update our count */
	    current = current->next;
	    ++count;
	 }
	 current_task = get_main_task_list()->head;
	 load_data_to_taskinfoPopup(current_task);
	 first = (int) xv_get(Main_mainWindow->taskList,
			      PANEL_LIST_FIRST_SELECTED);
	 if (first != -1) 
	   xv_set(Main_mainWindow->taskList, PANEL_LIST_SELECT,
		  first, FALSE, NULL);
	 xv_set(Main_mainWindow->mainWindow, FRAME_BUSY, FALSE, NULL);
	 xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_BUSY, FALSE,
		NULL);
	 xv_set(File_filePopup->filePopup, FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	 xv_set(File_filePopup->filePopup, XV_SHOW, FALSE, NULL);
      }
   }
   
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/* FUNCTION filePopup_done_callback ****************************************

   PURPOSE

   Done callback function for `filePopup'.

   INPUTS

   See XView manual.

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 30 Nov 1992
   Tester.... Mark M. Lacey, 30 Nov 1992

   MODIFICATIONS (most recent to least)

*/
void
filePopup_done_callback(Frame frame)
{
	xv_set(frame, XV_SHOW, FALSE, NULL);
	
	xv_set(Main_mainWindow->mainWindow, FRAME_BUSY, FALSE, NULL);
	xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_BUSY, FALSE,
	       NULL);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/* FUNCTION fileList_notify_callback ***********************************

   PURPOSE

   Notify callback function for `fileList'.

   INPUTS

   See XView manual.

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 30 Nov 1992
   Tester.... Mark M. Lacey, 30 Nov 1992

   MODIFICATIONS (most recent to least)

*/
int
fileList_notify_callback(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
   char wd[256];
   struct stat     s_buf;	/* points to file stat structure */

	file_filePopup_objects *ip = (file_filePopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		break;

	case PANEL_LIST_OP_SELECT:

		/* if the file exists */
		if (!stat(string, &s_buf)) {
		   /* and is a directory */
		   if (S_ISDIR(s_buf.st_mode)) {
		      /* change directories */
		      chdir(string);
		      /* get the current directory */
		      getwd(wd);

		      /* set the directory field */
		      xv_set(File_filePopup->directoryField, PANEL_VALUE,
			     wd, NULL);

		      xv_set(File_filePopup->filePopup, FRAME_BUSY,
			     TRUE, NULL);
			     
		      /* fill the filelist */
		      fill_filelist(wd);

		      xv_set(File_filePopup->filePopup, FRAME_BUSY,
			     FALSE, NULL);
		   } else {
		      /* if it wasn't a directory, fill the file field */
		      /* with it */
		      xv_set(File_filePopup->fileField, PANEL_VALUE,
			     string, NULL);
		   }
		}
		
	      case PANEL_LIST_OP_VALIDATE:
		break;
		
	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

/* FUNCTION directory_prompt_notify ****************************************

   PURPOSE

   Notify callback for 'directoryField'

   INPUTS

   See XView manual.

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 30 Nov 1992
   Tester.... Mark M. Lacey, 30 Nov 1992

   MODIFICATIONS (most recent to least)

*/
Panel_setting
directory_prompt_notify(Panel_item item, Event *event)
{
   Xv_notice notice;
   char wd[256];
   struct stat     s_buf;	/* points to file stat structure */

	file_filePopup_objects *ip = (file_filePopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char *	value = (char *) xv_get(item, PANEL_VALUE);
	
   /* if the file exists */ 
   if (!stat(value, &s_buf)) {
      /* and is a directory */
      if (S_ISDIR(s_buf.st_mode)) {
	 /* change directories */
	 chdir(value);
	 /* get the current directory */
	 getwd(wd);
	 xv_set(File_filePopup->directoryField, PANEL_VALUE,
		wd, NULL);
	 xv_set(File_filePopup->filePopup, FRAME_BUSY,
		TRUE, NULL);
	 
	 fill_filelist(wd);

	 xv_set(File_filePopup->filePopup, FRAME_BUSY,
		FALSE, NULL);
      } else {
	 notice = xv_create(File_filePopup->filePopup, NOTICE,
			    NOTICE_MESSAGE_STRINGS, 
			    "Directory does not exist", NULL,
			    NOTICE_BUTTON_YES, "Continue",
			    XV_SHOW, TRUE,
			    NULL);
	 xv_destroy_safe(notice);
      }
   }
   
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/* FUNCTION directory_prompt_notify ****************************************

   PURPOSE

   Notify callback for 'fileField'.

   Simulate pushing the 'apply' button on the screen.

   INPUTS

   See XView manual.

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 30 Nov 1992
   Tester.... Mark M. Lacey, 30 Nov 1992

   MODIFICATIONS (most recent to least)

*/
Panel_setting
file_prompt_notify(Panel_item item, Event *event)
{
	file_filePopup_objects *ip = (file_filePopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char *	value = (char *) xv_get(item, PANEL_VALUE);

	applyButton_callback(item, event);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return panel_text_notify(item, event);
}
