/*
 * rasview_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `rasview.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <gdd.h>
#include "rasview_ui.h"


/*
 * Global object definitions.
 */
rasview_win_objects	*Rasview_win;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

main(argc, argv)
	int	argc;
	char	**argv;
{
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 * Do NOT edit the object initializations by hand.
	 */
	Rasview_win = rasview_win_objects_initialize(NULL, NULL);
	
	/*
	 * Initialize the Drag Drop package.
	 */
	gdd_init_dragdrop(Rasview_win->win);
	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Rasview_win->win);
	exit(0);
}

#endif


/*
 * Menu handler for `file_menu (Load...)'.
 */
Menu_item
rasview_load_handler(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	rasview_win_objects * ip = (rasview_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		fputs("rasview: rasview_load_handler: MENU_NOTIFY\n", stderr);
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Clear)'.
 */
Menu_item
rasview_close_handler(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	rasview_win_objects * ip = (rasview_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		fputs("rasview: rasview_close_handler: MENU_NOTIFY\n", stderr);
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Drop callback function for `drop_target1'.
 */
void
canvas_drop_function(item, event, drop_info)
	Xv_opaque	item;
	Event		*event;
	GDD_DROP_INFO	*drop_info;
{
	rasview_win_objects *ip = (rasview_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("rasview: canvas_drop_function\n", stderr);
	fputs("Successful Drop. GDD_DROP_INFO contents:\n", stderr);
	gdd_print_drop_info(drop_info);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Drag callback function for `drop_target1'.
 */
void
rasview_drag_function(item, event, drop_info, drag_state)
	Xv_opaque	item;
	Event		*event;
	GDD_DROP_INFO	*drop_info;
	int		drag_state;
{
	rasview_win_objects *ip = (rasview_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (drag_state) {
	case GDD_DRAG_STARTED:
		break;

	case GDD_DRAG_COMPLETED:
		break;

	}
	fputs("rasview: rasview_drag_function\n", stderr);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Repaint callback function for `canvas'.
 */
void
rasview_canvas_repaint(canvas, paint_window, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Rectlist	*rects;
{
	fputs("rasview: rasview_canvas_repaint\n", stderr);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}
