#
/*
 *	lpq.c
 *	Peter Collinson - March 1977
 *	Prints current line printer queue entries
 *	with some indication of print length
 */

#define NOHDR	040
#define FWANTED	020
#define MAIL	010
#define DELETE	04
#define LIST	02
#define PR	01

#define INFSIZE 25

char lpd[]	"/usr/lpd";

int iobuf[259];

int infosize	0;

struct
{	int fill[4];
	char	gid;
	char	s0;
	int	size;
	int fill2[10];
	long	modtime;
} statb;

struct info
{	char	user[8];
	char	path[256];
	char	swit;
	char	file[128];
	long	creation;
	char	sz0;
	int	sz1;
} info[INFSIZE];

struct
{	int	inode;
	char	spoolname[14];
} dir;

struct
{	int	wd1;
	int	wd2;
};

long earliest;
long	reftime;

main()
{
	if((infosize = qlength()) == 0)
		printf("Line printer queue empty\n");
	else
	printtable();
	exit();
}

int qlength()
{	register int fd, sum;

	sum = 0;
	if((fd = open(lpd, 0)) < 0)
	{	printf("Cannot open /usr/lpd\n");
		exit();
	}

	seek(fd, 32, 0);	/* Avoid . and .. entries */
	while(read(fd, &dir, 16) > 0)
		if(dir.inode != 0 && dir.spoolname[0] == 'l' && dir.spoolname[1] == 'p')
			sum++;
	close(fd);
	return(sum);
}

printtable()
{	register int fd;
	struct info *entry;

	entry = &info;
	if((chdir(lpd) < 0) ||(fd = open(lpd, 0)) < 0)
	{	printf("Cannot open /usr/lpd\n");
		exit();
	}

	seek(fd, 32, 0);	/* Avoid . and .. entries */
	while(read(fd, &dir, 16) > 0)

	if(dir.inode != 0 && 
	   dir.spoolname[0] == 'l' && 
	   dir.spoolname[1] == 'p' && 
	   stat(dir.spoolname, &statb) >= 0 &&
	   readcontents(dir.spoolname, entry)) examine(entry++);

	time(&reftime);
	printf("lp queue on %s", ctime(&reftime));
	printf("Owner    Time queued     Size Options  File name\n");
	while(entry = findnext(info))
	{	printdetails(entry);
		entry->user[0] = '\0';
	}
}

struct info *findnext(start)
struct info *start;
{	register int i;
	register struct info *pt, *curr;

	earliest = reftime;
	pt = start; curr = 0;

	for(i = 0; i< infosize; i++)
	{	if(pt->user[0] != '\0' && pt->creation < earliest)
		{	earliest =  pt -> creation;
			curr = pt;
		}
		pt++;
	}
	return(curr);
}

examine(inf)
struct info *inf;
{	register struct info *in;

	in = inf;
	in-> creation = statb.modtime;
	if(chdir(in->path)< 0 || stat(in->file, &statb) < 0)
	{	printf("Cannot find: %s/%s\n", in->path, in->file);
		statb.s0 = 0;
		statb.size = 0;
	}
	in->sz0 = statb.s0;
	in->sz1 = statb.size;
	chdir(lpd);
}

printdetails(inf)
struct info *inf;
{	register struct info *in;
	register int wk, i;
	char s[6];

	in = inf;

	i = 0; wk = in->swit;
	if(wk&NOHDR) s[i++] = 'n';
	if(wk&FWANTED) s[i++] = 'f';
	if(wk&MAIL) s[i++] = 'm';
	if(wk&DELETE) s[i++] = 'd';
	if(wk&PR) s[i++] = 'p';
	if(wk&LIST) s[i++] = 'l';
	s[i] = '\0';

	printf("%-8.8s %-12.12s %7s   %-6.6s %s\n",
		in-> user, ctime(&in->creation)+4, locv(in->sz0, in->sz1), s, in-> file);
}

int readcontents(spoolerfile, inf)
char *spoolerfile;
struct info *inf;
{	register int ret;
	register struct info *fdata;
	ret = 1;
	fdata = inf;
	if(fopen(spoolerfile, iobuf) < 0)
	{	printf("Cannot open spoolerfile: %s\n", spoolerfile);
		exit();
	}

	if(readline(fdata->user) ||
	   readline(fdata->path) ||
	   ((fdata->swit = getc(iobuf)) < 0) ||
	   (getc(iobuf) != '\n') ||
	   readline(fdata->file)) ret = 0;
	close(iobuf[0]);
	return(ret);
}



int readline(dest)
char *dest;
{	register char *p, c; register int ret;
	p = dest; ret = 0;

	while((c = getc(iobuf)) != '\n')
	{	if(c < 0) { ret++; *dest == '0'; break;	}
		*p++ = c;
	}
	*p = '\0';
	return(ret);
}
