#
/*

 *	shutdown - program to kill unix.
 *	Issues warning messages to all users, then kills all processes
 *	in order of priority (copied from Peter C.'s killunix).
 */

char	*warning	"  SYSTEM GOING OFF WITHIN 2 MINUTES\n       shutdown is running\n";
int	abort;

#include	"../sys/param.h"

main()
	{
	int	anywall, finished, pid, newpid;
	char	c;
	extern	interrupt();

	/* Check if operating from console terminal */
	if (ttyn()!='8')  {
		printf("shutdown must be run from tty8\n");
		exit(-1);
		};


	nointerrupts();
	signal( SIGINT, interrupt );
	copy( "/etc/motd", "/etc/motd.b");
	setwarning( "/etc/motd" );

	/* Wait 2 minutes to shutdown */
	anywall = 0;
	delay(0);
	wall( "System going off in 2 minutes\n", &anywall );
	delay( 90 );
	wall( "System going off in 30 seconds\n", &anywall );
	delay( 30);
	wall( "Shutting down\n", &anywall );
	signal( SIGINT, 1 );

	/* Restore the message of the day */
	copy( "/etc/motd.b", "/etc/motd" );
	unlink( "/etc/motd.b" );
	killprocs("/unix");
	/* clobber the utmp file */
	close( creat("/etc/utmp", 0));

	sync();
	sleep(2);
	printf("\nHALT THE PROCESSOR\n\n");
	}
