/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)HomeAddress.c	1.3 84/08/20
*/

/*
**	Return true if address is us.
*/

#include	"global.h"
#include	"address.h"
#include	"state.h"



bool
HomeAddress(s, handler)
	char *		s;
	char **		handler;
{
	char		node[NODE_NAME_SIZE+1];
	NodeLink	nl;

	if ( strchr(s, DOMAIN_SEP) != NULLSTR )
	{
		register Address *	address = SplitAddress(s);
		register char **	cpp;
		register int		i;
		char *			domhandler;

		for
		(
			i = address->ad_domains,
			cpp = &address->ad_strings[i],
			domhandler = NULLSTR ;
			i-- > 0 ;
		)
		{
			if ( !HomeDomain(*cpp--, &domhandler) )
			{
				FreeAddress(address);
				return false;
			}

			if ( domhandler != NULLSTR )
			{
				*handler = domhandler;
				FreeAddress(address);
				return true;
			}
		}

		s = strncpy(node, address->ad_node, NODE_NAME_SIZE);
		node[NODE_NAME_SIZE] = '\0';

		FreeAddress(address);
	}

	if ( strcmp(s, HomeNode) == STREQUAL )
		return true;

	if ( FindNode(s, pt_msg, &nl) )
		return false;

	if ( HomeDomain(s, handler) )
		return true;

	return false;
}
