/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)NodeName.c	1.1 84/06/12
*/

/*
**	Routine to obtain our "HomeNode".
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"

#if	UNAME == 1

#include	<sys/utsname.h>



char *
NodeName()
{
	register int	n;
	struct utsname	SysNames;

	SysNames.nodename[0] = '\0';

	(void)uname(&SysNames);

	if ( (n = strlen(SysNames.nodename)) > NODE_NAME_SIZE || n == 0 )
		Fatal2("nodename too %s", n?"long":"short");

	return strcpy(Malloc(n+1), SysNames.nodename);
}
#endif	UNAME == 1



#if	GETHOST == 1

char *
NodeName()
{
	register int	n;
	static char	nodename[NODE_NAME_SIZE+2];

	strclr(nodename, sizeof nodename);

	if ( gethostname(nodename, sizeof(nodename)) == SYSERROR )
		Syserror("gethostname");

	if ( (n = strlen(nodename)) > NODE_NAME_SIZE || n == 0 )
		Fatal2("nodename too %s", n?"long":"short");

	return nodename;
}
#endif	GETHOST == 1



#if	UNAME != 1 && GETHOST != 1

static char *	NameFile	= NODENAMEFILE;



char *
NodeName()
{
	register char *	nodename;
	register int	n;

	if ( (nodename = ReadFile(NameFile)) == NULLSTR )
		Fatal2("cannot read \"%s\"", NameFile);

	if ( (n = strlen(nodename)) > NODE_NAME_SIZE || n == 0 )
		Fatal2("nodename too %s", n?"long":"short");

	return nodename;
}
#endif	UNAME != 1
