/*
**	Copyright 2012 Piers Lauder
**
**	This file is part of MHSnet.
**
**	MHSnet is free software: you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation, either version 3 of the License, or
**	(at your option) any later version.
**
**	MHSnet is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
**	You should have received a copy of the GNU General Public License
**	along with MHSnet.  If not, see <http://www.gnu.org/licenses/>.
*/


#define	STDIO
#define	TIME

#include	"global.h"
#include	"debug.h"
#include	"exec.h"
#include	"expand.h"
#include	"Passwd.h"


#define	Fprintf	(void)fprintf



/*
**	Send network originated report via mail to NCC_(ADMIN|MANAGER).
*/

char *
MailNCC(funcp, mngr)
	vFuncp		funcp;
	char *		mngr;
{
	register FILE *	fd;
	char *		cp;
	ExBuf		args;

	GetNetUid();

	if ( ExHomeAddress == NULLSTR )
		ExHomeAddress = NodeName();

	if ( ExSourceAddress == NULLSTR )
		ExSourceAddress = ExHomeAddress;

	if ( SenderName == NULLSTR )
		SenderName = NetPasswd.P_name;

	if ( UserName == NULLSTR )
		UserName = SenderName;

	if ( StartTime == 0 )
		StartTime = Time;

	FIRSTARG(&args.ex_cmd) = BINMAIL;
	ExpandArgs(&args.ex_cmd, BINMAILARGS);	/* Usually SenderName@ExSourceAddress */
	if ( mngr == NULLSTR || SplitArg(&args.ex_cmd, mngr) == 0 )
		NEXTARG(&args.ex_cmd) = mngr = "root";

	fd = (FILE *)Execute(&args, NULLVFUNCP, ex_pipe, SYSERROR);

	if ( MAIL_RFC822_HDR )
	{
		if ( SenderName == NetPasswd.P_name )
		{
			if ( (int)strlen(NetPasswd.P_rname) > 0 )
				cp = NetPasswd.P_rname;
			else
				cp = english("Network Daemon");

			Fprintf(fd, english("From: %s@%s (%s)\n"), SenderName, ExHomeAddress, cp);
		}
		else
			Fprintf(fd, english("From: %s@%s\n"), SenderName, ExHomeAddress);

		Fprintf(fd, english("Date: %s"), rfc822time(&Time));
	}

	if ( MAIL_TO )
	{
		if ( strchr(mngr, '@') == NULLSTR )
			Fprintf(fd, english("To: %s@%s\n"), mngr, ExHomeAddress);
		else
			Fprintf(fd, english("To: %s\n"), mngr);
	}

	(*funcp)(fd);

	Fprintf(fd, english("\nMail generated by network program \"%s\" [%d]\n"), Name, Pid);

	return ExClose(&args, fd);
}
