#!/bin/sh
#
#	@(#)checkq.sh	1.5 96/02/12
#
#	Start call to <link> ... if mail or file messages present.

USAGE='"Usage: `basename $0` [-m] link ...
This command starts a call [sends mail] for each <link>
if inactive and mail or file messages present."'

#	(First collect the args, as the `eval' below destroys them.)

args=
count=$#
mailonly=
case ${count} in
0)	;;
*)	for i
	do
		case "${i}" in
		-m)	mailonly=true
			;;
		-*|'')	eval echo "${USAGE}"
			exit 1
			;;
		*)	case "${args}" in
			'')	args="${i}"		;;
			*)	args="${args} ${i}"	;;
			esac
			;;
		esac
	done
	;;
esac

case "${args}" in
'')	eval echo "${USAGE}"
	exit 1
	;;
esac

SPOOLDIR=/usr/spool/MHSnet
eval `egrep 'SPOOLDIR' /usr/lib/MHSnetparams 2>/dev/null`
cd ${SPOOLDIR}

for link in ${args}
do
	link=`_bin/netaddr ${link}`

	_bin/netaddr -L ${link} >/dev/null || continue

	_bin/netcontrol -sL `_bin/netaddr -l ${link}`/cmds && continue

	call=false
	for msg in mailer filer
	do
		_bin/netq -acsA${msg} ${link} || call=true
		case ${call} in
		true)	break	;;
		esac
	done

	case "${call}" in
	true)			;;
	*)	continue	;;
	esac

	case "${mailonly}" in
	true)	eval `_bin/netparams -w NCC_ADMIN`
		_bin/netmail -mort \
			LOGNAME=postmaster \
			NAME="MHSnet Queue Checker" \
			SUBJECT="Network queue to ${link} non-empty." \
			"Network Admin <$NCC_ADMIN>" <<!
The inactive link to ${link} is non-empty.

Mail generated by network program "$0" [$$]
!
		;;
	*)	_bin/netcontrol start call-${link}
		;;
	esac
done

exit 0
