#!/bin/sh
#
#	@(#)checklink.sh	1.1 06/08/28
#
#	Notify ADMIN if link(s) down.

USAGE='"Usage: `basename $0` link ...
This command sends mail for each <link> that is inactive."'

#	(First collect the args, as the `eval' below destroys them.)

args=
count=$#
mailonly=
case ${count} in
0)	;;
*)	for i
	do
		case "${i}" in
		-*|'')	eval echo "${USAGE}"
			exit 1
			;;
		*)	case "${args}" in
			'')	args="${i}"		;;
			*)	args="${args} ${i}"	;;
			esac
			;;
		esac
	done
	;;
esac

case "${args}" in
'')	eval echo "${USAGE}"
	exit 1
	;;
esac

SPOOLDIR=/usr/spool/MHSnet
eval `egrep 'SPOOLDIR' /usr/lib/MHSnetparams 2>/dev/null`
cd ${SPOOLDIR}

for link in ${args}
do
	# Get FQDN
	link=`_bin/netaddr ${link}`

	# Ignore if not name of local link
	_bin/netaddr -L ${link} >/dev/null || continue

	# Ignore if link lockfile present and active
	_bin/netcontrol -sL `_bin/netaddr -l ${link}`/cmds && continue

	# We have an inactive link: send mail to ADMIN

	eval `_bin/netparams -w NCC_ADMIN`
	_bin/netmail -mort \
		LOGNAME=linkmaster \
		NAME="MHSnet Link Checker" \
		SUBJECT="Network link to ${link} is down." \
		"Network Admin <$NCC_ADMIN>" <<!
The link to ${link} is inactive.

Mail generated by network program "$0" [$$]
!
done

exit 0
