/*
**	Copyright (c) 1987 Piers Lauder, University of Sydney.
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID	@(#)statefile.h	1.11 88/09/27
*/

/*
**	The state file is an ascii file, except for the last line,
**	which contains the bytes:-
**		C_EOF
**		LOCRC
**		HICRC
**		'\n'
**
**	The CRC checks all the bytes on the preceding lines.
*/

/*
**	Separators used between tokens in state file.
*/

#define	TOKEN_SIZE	127

typedef enum
{
	t_domhier, t_domain, t_othdom, t_topdom,
	t_alias, t_aliasv, t_xalias,
	t_node, t_nflags, t_comment, t_state, t_nodehier,
	t_connector, t_spooler, t_caller, t_handler, t_filter,
	t_date, t_sent, t_recvd, t_passto, t_passfrom,
	t_link, t_lflags, t_cost, t_speed, t_time, t_bytes,
	t_eof, t_expect,
	t_n,				/* [30] */
	t_nextlink, t_nextnode,
	t_max, t_null, t_error
}
			Token;

typedef long		Tokens;	/* Enough bits for 1<<t_n */

#ifdef	STATE_FILE_DATA

#ifdef	DEBUG
char *	TokenNames[] =
{
	"domhier", "domain", "othdom", "topdom",
	"alias", "aliasv", "xalias",
	"node", "nflags", "comment", "state", "nodehier",
	"connector", "spooler", "caller", "handler", "filter",
	"date", "sent", "recvd", "passto", "passfrom",
	"link", "lflags", "cost", "speed", "time", "bytes",
	"eof", "expect",
	"n",
	"nextlink", "nextnode",
	"max", "null", "error"
};
#endif	/* DEBUG */

/*
**	Mask bits per token type.
*/

#define	T_ALIAS		(Tokens)(1L<<(int)t_alias)
#define	T_ALIASV	(Tokens)(1L<<(int)t_aliasv)
#define	T_ANY		(Tokens)(1L<<(int)t_any)
#define	T_BYTES		(Tokens)(1L<<(int)t_bytes)
#define	T_CALLER	(Tokens)(1L<<(int)t_caller)
#define	T_COMMENT	(Tokens)(1L<<(int)t_comment)
#define	T_CONNECTOR	(Tokens)(1L<<(int)t_connector)
#define	T_COST		(Tokens)(1L<<(int)t_cost)
#define	T_DATE		(Tokens)(1L<<(int)t_date)
#define	T_DOMAIN	(Tokens)(1L<<(int)t_domain)
#define	T_DOMHIER	(Tokens)(1L<<(int)t_domhier)
#define	T_EOF		(Tokens)(1L<<(int)t_eof)
#define	T_EXPECT	(Tokens)(1L<<(int)t_expect)
#define	T_FILTER	(Tokens)(1L<<(int)t_filter)
#define	T_FOREIGN	(Tokens)(1L<<(int)t_foreign)
#define	T_HANDLER	(Tokens)(1L<<(int)t_handler)
#define	T_IGNORE	(Tokens)(1L<<(int)t_ignore)
#define	T_LFLAGS	(Tokens)(1L<<(int)t_lflags)
#define	T_LINK		(Tokens)(1L<<(int)t_link)
#define	T_NFLAGS	(Tokens)(1L<<(int)t_nflags)
#define	T_NODE		(Tokens)(1L<<(int)t_node)
#define	T_NODEHIER	(Tokens)(1L<<(int)t_nodehier)
#define	T_OTHDOM	(Tokens)(1L<<(int)t_othdom)
#define	T_PASSFROM	(Tokens)(1L<<(int)t_passfrom)
#define	T_PASSTO	(Tokens)(1L<<(int)t_passto)
#define	T_RECVD		(Tokens)(1L<<(int)t_recvd)
#define	T_SENT		(Tokens)(1L<<(int)t_sent)
#define	T_SPEED		(Tokens)(1L<<(int)t_speed)
#define	T_SPOOLER	(Tokens)(1L<<(int)t_spooler)
#define	T_STATE		(Tokens)(1L<<(int)t_state)
#define	T_TIME		(Tokens)(1L<<(int)t_time)
#define	T_TOPDOM	(Tokens)(1L<<(int)t_topdom)
#define	T_XALIAS	(Tokens)(1L<<(int)t_xalias)

#endif	/* STATE_FILE_DATA */

/*
**	Actual statefile tokens.
*/

#define	C_ALIAS		'~'
#define	C_ALIASV	'^'
#define	C_BYTES		'='
#define	C_CALLER	'\\'
#define	C_COMMENT	'"'
#define	C_CONNECTOR	'&'
#define	C_COST		'$'
#define	C_DATE		'@'
#define	C_DOMAIN	'|'
#define	C_DOMHIER	';'
#define	C_EOF		'#'
#define	C_FILTER	'('
#define	C_HANDLER	'%'
#define	C_LFLAGS	'`'
#define	C_LINK		','
#define	C_NFLAGS	'\''
#define	C_NODE		'\n'
#define	C_NODEHIER	'+'
#define	C_OTHDOM	']'
#define	C_PASSFROM	'<'
#define	C_PASSTO	'>'
#define	C_RECVD		'{'
#define	C_SENT		'}'
#define	C_SPEED		'*'
#define	C_SPOOLER	'!'
#define	C_STATE		'?'
#define	C_TIME		':'
#define	C_TOPDOM	'['
#define	C_XALIAS	'/'

#define	C_SPARE2	')'

#ifdef	STATE_FILE_DATA

/*
**	Token expectations.
*/

#define	t_start		t_domhier

#define	F_START		T_DOMHIER|T_XALIAS|T_NODE
#define	F_NODE		T_DOMAIN|T_NFLAGS|T_COMMENT|T_LINK|T_NODE
#define	F_LINK		T_NODEHIER|T_LFLAGS|T_SPEED|T_COST|T_LINK|T_NODE

#define	L_START		F_START|T_ALIAS
#define	L_NODE_1	F_NODE|T_NODEHIER|T_OTHDOM|T_TOPDOM|T_STATE|T_DATE|T_RECVD|T_SENT
#define	L_NODE		L_NODE_1|T_PASSTO|T_PASSFROM|T_SPOOLER|T_CONNECTOR|T_CALLER|T_FILTER
#define	L_LINK		T_LFLAGS|T_SPEED|T_COST|T_TIME|T_BYTES|T_LINK|T_NODE

/*
**	Token expectations of statefile order.
**
**	Token expectations array in same order as Token.
**
**	(local)				(foreign)
*/

Tokens	Accept[(int)t_max][2] =
{
	{ L_START,			F_START		},	/* t_domhier */
	{ L_NODE|T_HANDLER,		F_NODE		},	/* t_domain */
	{ L_NODE|T_HANDLER,		F_NODE		},	/* t_othdom */
	{ L_NODE|T_HANDLER,		F_NODE		},	/* t_topdom */
	{ T_ALIASV|T_EXPECT,		F_NODE		},	/* t_alias */
	{ T_ALIAS|T_XALIAS|T_NODE,	F_NODE		},	/* t_aliasv */
	{ T_ALIAS|T_XALIAS|T_NODE,	T_XALIAS|T_NODE	},	/* t_xalias */
	{ L_NODE,			F_NODE		},	/* t_node */
	{ L_NODE,			F_NODE		},	/* t_nflags */
	{ L_NODE,			F_NODE		},	/* t_comment */
	{ L_NODE,			F_NODE		},	/* t_state */
	{ L_NODE,			F_LINK		},	/* t_nodehier */
	{ L_NODE,			F_NODE		},	/* t_connector */
	{ L_NODE,			F_NODE		},	/* t_spooler */
	{ L_NODE,			F_NODE		},	/* t_caller */
	{ L_NODE,			F_NODE		},	/* t_handler */
	{ L_NODE,			F_NODE		},	/* t_filter */
	{ L_NODE,			F_NODE		},	/* t_date */
	{ L_NODE,			F_NODE		},	/* t_sent */
	{ L_NODE,			F_NODE		},	/* t_recvd */
	{ L_NODE,			F_NODE		},	/* t_passto */
	{ L_NODE,			F_NODE		},	/* t_passfrom */
	{ L_LINK,			F_LINK		},	/* t_link */
	{ L_LINK,			F_LINK		},	/* t_lflags */
	{ L_LINK,			F_LINK		},	/* t_cost */
	{ L_LINK,			F_LINK		},	/* t_speed */
	{ L_LINK,			F_LINK		},	/* t_time */
	{ L_LINK,			F_LINK		},	/* t_bytes */
	{ 0,				0		},	/* t_eof */
	{ 0,				0		},	/* t_expect */
	{ 0,				0		},	/* t_n */
	{ T_LINK|T_NODE,		T_LINK|T_NODE	},	/* t_nextlink */
	{ T_NODE,			T_NODE		}	/* t_nextnode */
};

#endif	/* STATE_FILE_DATA */

/*
**	Control type of statefile
*/

typedef enum
{
	t_local, t_export, t_allexport
}
			Export_t;

/*
**	Miscellaneous variables
*/

extern bool		ChangeState;		/* True if vital info. about Home has changed and should be propagated */
extern bool		AnteState;		/* True if state info. is out-of-date */
