/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FindAddress.c	1.22 89/11/25
*/

/*
**	Return true if address is known,
**	(know route to node, or nearest domain),
**	fill NodeLink structure with the route details,
**	if home domains found, make up a new reduced address in "dest".
*/

#include	"global.h"
#include	"address.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"



bool
FindAddress(dest, nlp)
	char *		dest;
	NodeLink *	nlp;
{
	register char *	cp;
	bool		noclobber = false;
	bool		clobberred = false;
	int		acount = 0;

	Trace2(1, "FindAddress \"%s\"", dest);

again:
	if ( (cp = strchr(dest, DOMAIN_SEP)) != NULLSTR )
	{
		register Address *	address = SplitAddress(dest);
		register char **	cpp;
		register int		i;
		int			lasthier;
		int			node_index;
		int			node_link;
		int			home_index;
		bool			known_node;
		bool			non_member;
		bool			foreign_domain;
		extern bool		Member();

		if ( FindNode(address->ad_node, pt_msg, nlp) )
		{
			non_member = false;
			known_node = true;
			node_index = nlp->nl_index;
			node_link = nlp->nl_link;
			home_index = address->ad_domains;
		}
		else
			known_node = false;

		foreign_domain = false;

		/*
		**	Search back through domain hierarchy
		*/

		lasthier = LevelCount;

		for
		(
			i = address->ad_domains,
			cpp = &address->ad_strings[i] ;
			i > 0 ;
			i--
		)
		{
			register int	hier;

			if ( !FindDomain(*cpp--, nlp) )
			{
				FreeAddress(address);
				return false;
			}

			if
			(
				foreign_domain
				||
				nlp->nl_link != (NodeCount-1)
				&&
				(
					(hier = RT_DOMAIN(nlp->nl_domind)->de_hierarchy) == LINK_N_A
					||
					--hier < 0
					||
					(hier = *RT_LEVEL(hier)) == LINK_N_A
					||
					strccmp(*cpp, RT_DOMAIN(hier)->de_name) != STREQUAL
				)
			)
			{
				NodeLink	nl;

				if
				(
					known_node
					&&
					Member(node_index, nlp->nl_domind)
					&&
					node_link != nlp->nl_link
					&&
					(i == 1 || FindDomain(*cpp, &nl))
				)
				{
					non_member = false;
					foreign_domain = true;
					Trace2(2, "FindAddress discard known domain \"%s\"", cpp[1]);
					continue;
				}

				/*
				**	Foreign domain encountered,
				**	so use route to it.
				**
				**	Make up new reduced destination address.
				*/

				if ( known_node && i != home_index )
				{
					i = home_index;
					(void)FindDomain(address->ad_strings[i], nlp);
				}

				FreeAddress(address);
				return true;
			}

			if ( (hier = RT_DOMAIN(nlp->nl_domind)->de_hierarchy) != LINK_N_A )
			{
				if ( hier >= lasthier )	/* Wrong place in hierarchy */
				{
					nlp->nl_name = "inverted hierarchy";
					FreeAddress(address);
					return false;	/* Can't resolve this address */
				}

				lasthier = hier;
			}

			if ( known_node && !Member(node_index, nlp->nl_domind) )
				non_member = true;
			else
				non_member = false;	/* Local nodes needn't be members of higher domains */

			home_index = i - 1;

			Trace2(2, "FindAddress discard home domain \"%s\"", cpp[1]);
		}

		/*
		**	Recognised home domain hierarchy,
		**	so the node/domain name is unique.
		*/

		if ( known_node && non_member )
		{
			nlp->nl_name = "unknown";
			FreeAddress(address);
			return false;	/* Probably wrong domain */
		}

		if ( !noclobber )
		{
			*cp = '\0';
			clobberred = true;
		}

		FreeAddress(address);

		if ( !known_node && FindDomain(dest, nlp) && nlp->nl_link < LinkCount )
		{
			if ( clobberred )
				*cp = DOMAIN_SEP;
			return true;
		}

		Trace2(2, "FindAddress with unique node name \"%s\"", dest);
	}

	if
	(
		!FindNode(dest, pt_msg, nlp)
		&&
		(
			!FindDomain(dest, nlp)
			||
			nlp->nl_link >= LinkCount && ++acount && (nlp->nl_name = "own domain")
		)
	)
	{
		/** No luck, try for an alias **/

		if ( acount++ == 0 && (dest = FindAlias(dest)) != NULLSTR )
		{
			noclobber = true;
			if ( clobberred )
			{
				*cp = DOMAIN_SEP;
				clobberred = false;
			}
			goto again;
		}

		if ( clobberred )
			*cp = DOMAIN_SEP;

		return false;
	}

	if ( clobberred )
		*cp = DOMAIN_SEP;

	return true;
}



/*
**	Test whether node 'n' is a member of domain 'd'.
**
**	(Should go in own file soon.)
*/

bool
Member(n, d)
	int		n;
	int		d;
{
	register int	i;

	DODEBUG(if(n>=NodeCount)Fatal("Illegal node index %d passed to Member()",n));
	DODEBUG(if(d>=DomainCount)Fatal("Illegal domain index %d passed to Member()",d));

	i = n * DomainCount;
	i += d;
	i = MemberTable[i/8] & (1<<(i%8));

	Trace4(2, "Member(%s, %s)==>%s", RT_NODE(n)->ne_name, RT_DOMAIN(d)->de_name, (i != 0)?"true":"false");

	return (i != 0) ? true : false;
}
