/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FindAlias.c	1.1 84/06/12
*/

/*
**	Given an alias, find true address in Strings.
**
**	Uses binary search to find alias in routing tables.
**
**	If 'name' is an alias, return the true address.
**
**	If 'name' is not an alias, return NULLSTR.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


char *
FindAlias(name)
	char *		name;	/* Alias to be mathched */
{
	register char *	cp1;	/* String comparison temporary */
	register char *	cp2;	/* String comparison temporary */
	register char *	l;	/* First alias in table */
	register char *	u;	/* Last alias in table */
	register int	n;	/* Number of alias in table */
	register char *	i;	/* Approximate middle alias in table*/

	Trace2(1, "FindAlias for \"%s\"", name);

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
			return NULLSTR;

	n = AliasCount-1;
	l = AliasTable;
	u = &l[ALIAS_ENTRY_SIZE * n];

	while ( u >= l )
	{
		i = &l[ALIAS_ENTRY_SIZE * (n/2)];

		Trace3
		(
			2,
			"FindAlias => \"%s\", value \"%s\"",
			((AliasEntry *)i)->ae_name,
			&Strings[((AliasEntry *)i)->ae_value]
		);

		for
		(
			cp1 = name, cp2 = ((AliasEntry *)i)->ae_name ;
			*cp1 == *cp2++ ;
		)
		{
			if ( *cp1++ != '\0' )
				continue;

			return &Strings[((AliasEntry *)i)->ae_value];
		}

		if ( *cp1 < *--cp2 )
			u = i-ALIAS_ENTRY_SIZE;
		else
			l = i+ALIAS_ENTRY_SIZE;

		n = (u-l)/ALIAS_ENTRY_SIZE;
	}

	return NULLSTR;
}
