#include	<stdio.h>
#include	<dk.h>

#define	CMD	"NNdaemon"
#define	PATH	"/usr/ACSnet/spool/_lib/NNdaemon"
#define	FLAGS	"-BF"

int
main(argc, argv)
int	argc;
char	*argv[];
{
	register int	fd;
	register int	i;
	char		*from;
	char		*to;
	char		*sw;
	char		*my_name;
	char		buff[512];
	extern int	dkp_ld;
	extern int	dkverbose;
	extern char	*strrchr();

	if ((my_name = strrchr(argv[0], '/')) == NULL || *++my_name == '\0')
		my_name = argv[0];

	if (argc != 4)
	{
		fprintf(stderr, "usage: %s switch from to\n", my_name);
		return 1;
	}

	sw = argv[1];
	from = argv[2];
	to = argv[3];

	dkverbose = 1;

	sprintf(buff, "%s/%s.exec.%s", sw, to, CMD);

	if ((fd = tdkdial(buff, 2)) < 0)
	{
		fprintf(stderr, "%s: tdkdial(%s) failed\n", my_name, buff);
		return 1;
	}

	if (dkproto(fd, dkp_ld) < 0)
	{
		fprintf(stderr, "%s: dkproto failed\n", my_name);
		return 1;
	}

	if (tdklogin(fd) < 0)
	{
		fprintf(stderr, "%s: could not login\n", my_name);
		return 1;
	}

	sprintf(buff, "%s %s %s\n", PATH, FLAGS, from);
	i = strlen(buff);

	if (write(fd, buff, i) != i)
	{
		fprintf(stderr, "%s: could not write command\n", my_name);
		perror("write");
		return 1;
	}

	close(1);

	switch (dup(fd))
	{
	case -1:
		fprintf(stderr, "%s: could not dup remote fd\n", my_name);
		perror("dup");
		return 1;

	case 1:
		break;

	default:
		fprintf(stderr, "%s: failed to get fd 1\n", my_name);
		return 1;
	}

	execl(PATH, CMD, FLAGS, to, (char *)NULL);
	fprintf(stderr, "%s: could not exec %s\n", my_name, PATH);
	perror("NNdaemon");
	return 1;
}
