/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetRaw.c	1.11 84/10/09
*/

/*
**	Set RAW mode on 'tty' link
*/

#define	TERMIOCTL

#include	"global.h"
#include	"debug.h"



int
SetRaw(fd, speed, minchars, mintime, xon_xoff)
	int	fd;
	int	speed;
	int	minchars;
	int	mintime;
	bool	xon_xoff;
{
#	if	SYSTEM < 3
	struct sgttyb	params;

	Trace3(1, "SetRaw speed=%d, xon_xoff=%d", speed, xon_xoff);

	if ( gtty(fd, &params) == SYSERROR )
		return;

	if ( speed )
		params.sg_ispeed = params.sg_ospeed = speed;
	else
		speed = params.sg_ispeed;

	if ( xon_xoff )
		params.sg_flags = EVENP|ODDP
#				ifdef	CBREAK
				  |CBREAK
#				endif	CBREAK
#				ifdef	TANDEM
				  |TANDEM
#				endif	TANDEM
				  ;
	else
		params.sg_flags = RAW;

	(void)stty(fd, &params);

#	else	SYSTEM < 3
	struct termio	params;

	Trace5(1, "SetRaw speed=%d, minch=%d, mintim=%d, xon_xoff=%d", speed, minchars, mintime, xon_xoff);

	if ( ioctl(fd, TCGETA, &params) == SYSERROR )
		return;

	params.c_iflag &= ~(ISTRIP|IUCLC|INLCR|ICRNL|IGNCR|IXOFF|IXON|IXANY|INPCK|BRKINT);
	params.c_iflag |= IGNBRK|IGNPAR;
	if ( xon_xoff )
		params.c_iflag |= IXON|IXOFF;
	params.c_oflag &= ~OPOST;
	if ( speed )
	{
		params.c_cflag &= ~(CBAUD|PARENB);
		params.c_cflag |= speed|CREAD;
	}
	else
	{
		params.c_cflag &= ~PARENB;
		params.c_cflag |= CREAD;
		speed = params.c_cflag & CBAUD;
	}
	params.c_lflag = 0;

	params.c_cc[VMIN] = minchars == 0 ? 32 : minchars;
	params.c_cc[VTIME] = mintime == 0 ? 1 : mintime;

	(void)ioctl(fd, TCSETA, &params);

#	endif	SYSTEM < 3

	Trace2(1, "SetRaw returns %d", speed);

	return speed;
}
