/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)RdStats.c	1.3 84/07/24
*/

/*
**	Save statistics file, make a new (empty) one, and read the old one.
*/

#define	FILE_CONTROL
#define	LOCKING
#define	STDIO

#include	"global.h"
#include	"stats.h"


static char *	StatsFile;

extern Time_t	Time;


void
RdStats(idp, funcp, move)
	char *		idp;
	bool		(*funcp)();
	bool		move;
{
	register FILE *	fd;

	if ( StatsFile == NULLSTR )
		StatsFile = STATSFILE;

	if
	(
		access(StatsFile, 0) == SYSERROR
		||
		(fd = fopen(StatsFile, move?"r+":"r")) == NULL
	)
		return;
	
	if ( move )
	{
		register int	ofd;
		char *		fn;
		static char *	totals = ACCSTATS;

		Lock(StatsFile, fileno(fd), for_writing);

		fn = UniqueName(newstr(STATSDIR(statsfile.back)), (long)0, Time);

		if
		(
			link(StatsFile, fn) == SYSERROR
			||
			unlink(StatsFile) == SYSERROR
			||
			MakeLock(StatsFile) == SYSERROR
		)
		{
			UnLock(fileno(fd));
			(void)fclose(fd);
			return;
		}

		UnLock(fileno(fd));

		if ( (ofd = open(totals, O_WRITE)) != SYSERROR )
		{
			register int	n;
			register int	r;
			char		buf[BUFSIZ];

			(void)lseek(ofd, (long)0, 2);

#			if	AUTO_LOCKING == 1

			for ( r = 0 ;; )
			{
				(void)Lock(fn, fileno(fd), for_reading);

				if ( (n = read(fileno(fd), buf, BUFSIZ)) > 0 )
				{
					UnLock(fileno(fd));

					(void)Lock(totals, ofd, for_writing);

					if ( (r = write(ofd, buf, n)) != n )
						break;
					
					UnLock(ofd);
				}
				else
					break;
			}

#			else	AUTO_LOCKING == 1

			(void)Lock(totals, ofd, for_writing);

			while ( (n = read(fileno(fd), buf, BUFSIZ)) > 0 )
				if ( (r = write(ofd, buf, n)) != n )
					break;

#			endif	AUTO_LOCKING == 1

			UnLock(ofd);
			(void)close(ofd);

			if ( r != SYSERROR )
				(void)unlink(fn);

			rewind(fd);
		}
		else
			(void)unlink(fn);

#		if	AUTO_LOCKING == 1
		(void)Lock(fn, fileno(fd), for_reading);
#		endif	AUTO_LOCKING == 1

		free(fn);
	}

	Rstats(idp, funcp, fd);

	(void)fclose(fd);
}



void
NewStats(newfile)
	char *	newfile;
{
	StatsFile = newfile;
}
