/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)MakeEnv.c	1.1 84/06/12
*/


/*
**	Concatenate strings into header environment.
**	Variable number of argument pairs terminated by a NULLSTR.
*/

#include	"global.h"
#include	"header.h"


char		EnvRestricted[]	= { ENV_RS, ENV_SEP, '\0' };

extern void	QuoteChars();



/*VARARGS2*/
char *
MakeEnv(name, value)
	char *		name;
	char *		value;
{
	char **		cpp;
	register char *	cp;
	register char *	np;
	register char *	vp;
	register int	size;
	char *		string;

	for
	(
		size = 0, cpp = &name ;
		(np = ARGS_OFF_STACK(cpp)) != NULLSTR ;
	)
	{
		size += strlen(np) + 2;

		if ( (vp = ARGS_OFF_STACK(cpp)) != NULLSTR )
			size += strlen(vp);
	}
	
	string = cp = Malloc(size+1);

	for
	(
		cpp = &name ;
		(np = ARGS_OFF_STACK(cpp)) != NULLSTR ;
	)
	{
		register char *	ocp;

		*cp++ = ENV_RS;
		cp = strcpyend(cp, np);

		if ( (vp = ARGS_OFF_STACK(cpp)) != NULLSTR )
		{
			*cp++ = ENV_SEP;
			ocp = cp;
			cp = strcpyend(cp, vp);
			QuoteChars(ocp, EnvRestricted);
		}
	}

	return string;
}
