/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)bad.c	1.1 84/06/12";

/*
**	Handle bad messages
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	STDIO

#include	"global.h"

#include	"debug.h"


/*
**	Parameters set from arguments.
*/

char *	Commandfile;		/* Bad command file */
char *	Errorstring;		/* Error string (also used by 'readit()') */
char *	Errorfile;		/* Error file */
char *	HomeNode;		/* Name of this node */
char *	Invoker;		/* Program that detected error */
char *	Message;		/* Message in question */
char *	Name;			/* Program invoked name */
char *	LinkNode;		/* Message had arrived from this node */
int	Traceflag;		/* Global tracing control */

/*
**	Miscellaneous
*/

#define	MAXBYTES	200	/* Maximum bytes mailed from an error file */
#define	MAXCOLS		66	/* Maximum columns used in mail items */

char *	DataName;		/* Needed by 'ExpandArgs()' */
int	Pid;			/* Used by UniqueName() in Exec...() */
char *	SenderName;		/* Needed by 'ExpandArgs()' */
char *	SourceNode;		/* Needed by 'ExpandArgs()' */
int	Size;			/* Size of string output by writeit() */
Time_t	Time;			/* Used by UniqueName() in Exec...() */
char *	UserName;		/* Needed by 'ExpandArgs()' */

#define	Fprintf		(void)fprintf
#define	free(A)

extern FILE *	ExecPipe();
void	bad(), finish(), writeit();
char *	readit();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	DODEBUG(EchoArgs(argc, argv));

	Pid = getpid();
	Time = time((long *)0);

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'd':
					Commandfile = ++*argv;
					goto break2;

				case 'e':
					Errorstring = ++*argv;
					goto break2;

				case 'f':
					Errorfile = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'i':
					Invoker = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				default:
					Error("unrecognised flag '%c'", c);
					return 1;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
			Message = *argv;
	}

	if ( Message == NULLSTR && Commandfile == NULLSTR )
		Error("no bad message/commands");

	if ( HomeNode == NULLSTR )
		HomeNode = NodeName();

	SourceNode = HomeNode;
	SenderName = ACSNETNAME;
	UserName = SenderName;

	bad();

	return 0;
}



/*
*/

void
finish(error)
	int	error;
{
	(void)exit(error);
}



/*
**	Process bad message/commands file.
**
**	Send mail to local guru and NCC.
*/

void
bad()
{
	register FILE *	fd;
	register char *	errs;
	VarArgs		args;
	static char *	eof = "EOF%s\n\n";

	FIRSTARG(&args) = BINMAIL;
#	ifdef	BINMAILARGS
	ExpandArgs(&args, BINMAILARGS, NULLSTR);
#	endif	BINMAILARGS
#	ifdef	NCC_MANAGER
	NEXTARG(&args) = NCC_MANAGER;
#	endif	NCC_MANAGER
#	ifdef	FUZZ
	NEXTARG(&args) = FUZZ;
#	endif	FUZZ

	fd = ExecPipe(&args);

	Fprintf(fd, "From %s %s", SenderName, ctime(&Time));
	Fprintf(fd, "Subject: ACSnet %s at %s\n\n", Name, HomeNode);

	if ( Invoker != NULLSTR )
		Fprintf(fd, "Invoked by \"%s\"\n\n", Invoker);

	if ( LinkNode != NULLSTR && LinkNode[0] != '\0' )
		Fprintf(fd, "Link \"%s\"\n\n", LinkNode);

	if ( Errorstring != NULLSTR )
	{
		Fprintf(fd, "Error message <<EOF\n");
		if ( (Size = strlen(Errorstring)) > 0 )
			writeit(fd, Errorstring);
		Fprintf(fd, eof, "");
	}

	if ( Errorfile != NULLSTR )
	{
		Fprintf(fd, "Error file \"%s\" <<EOF\n", Errorfile);

		if ( (Errorfile = readit(Errorfile, false)) != NULLSTR )
		{
			writeit(fd, Errorfile);
			free(Errorfile);
		}

		Fprintf(fd, eof, Errorstring);
	}

	if ( Message != NULLSTR )
	{
		Fprintf(fd, "End of message in \"%s\" <<EOF\n", Message);

		if ( (Message = readit(Message, true)) != NULLSTR )
		{
			writeit(fd, Message);
			free(Message);
		}

		Fprintf(fd, eof, Errorstring);
	}

	if ( Commandfile != NULLSTR )
	{
		Fprintf(fd, "Beginning of commands in \"%s\" <<EOF\n", Commandfile);

		if ( (Commandfile = readit(Commandfile, false)) != NULLSTR )
		{
			writeit(fd, Commandfile);
			free(Commandfile);
		}

		Fprintf(fd, eof, Errorstring);
	}

	if ( (errs = ExPipeClose(fd)) != NULLSTR )
	{
		/*
		**	Not much one can do about this, except report the evidence.
		*/

		Error(errs);
	}
}



char *
readit(file, end)
	char *		file;
	bool		end;
{
	register int	fd;
	register int	size;
	long		offset;
	int		whence;
	struct stat	statb;

	Errorstring = "";

	while ( (fd = open(file, O_READ)) == SYSERROR )
	{
		Errorstring = " (Can't open file)";
		return NULLSTR;
	}

	if ( fstat(fd, &statb) == SYSERROR )
	{
		Errorstring = " (Can't fstat file)";
		return NULLSTR;
	}

	if ( (size = statb.st_size) > MAXBYTES )
		size = MAXBYTES;
	
	if ( size > 0 )
	{
		file = Malloc(size);

		if ( end )
		{
			offset = -size;
			whence = 2;
		}
		else
		{
			offset = 0;
			whence = 0;
		}

		if ( lseek(fd, offset, whence) == SYSERROR )
		{
			Errorstring = " (Can't seek file)";
			return NULLSTR;
		}

		if ( read(fd, file, size) != size )
		{
			Errorstring = " (Can't read file)";
			return NULLSTR;
		}
	}
	else
		Errorstring = " (zero length)";

	(void)close(fd);

	return (Size = size) > 0 ? file : NULLSTR;
}



void
writeit(fd, file)
	register FILE *	fd;
	register char *	file;
{
	register int	c;
	register int	n;
	register int	col;

	putc('\t', fd);

	for ( n = Size, col = 0 ; n-- ; )
	{
		if
		(
			(
				(c = *file++) < ' '
				&&
				c != '\n'
				&&
				c != '\t'
			)
			||
			c >= '\177'
			||
			c == '\\'
		)
		{
			Fprintf(fd, "\\%03o", c&0xff);
			col += 4;
		}
		else
		{
			switch ( c )
			{
			case '\n':
				col = -1;
				break;

			case '\t':
				col |= 7;
			}

			putc(c, fd);
		}

		if ( ++col > MAXCOLS )
		{
			putc('\\', fd);
			putc('\n', fd);
			col = 0;
		}

		if ( col == 0 )
		{
			putc('\t', fd);
			col = 8;
		}
	}

	if ( col > 0 )
		putc('\n', fd);

	(void)fflush(fd);

	if ( ferror(fd) )
	{
		Syserror("Can't write to pipe");
		clearerr(fd);
	}
}
