#! /bin/sh

#
# Print SunIII statistics
#
#	Usage: statsprint [ when ]
#
#		``when'' is one of
#				a (4 digit) year
#				a (1 or 2 digit) day of the month
#				a day of the week
#				a month of the year
#				the two letters "wk" followed by a digit
#				the word "yesterday"
#
#		default is to print accumulated stats forever
#

Usage="Usage: statsprint [ when ]"

case $# in
0)	arg1=" accumulated" arg2="" file="";;
1)	case "$1" in
	[Ss]un*)	arg1="" arg2=" for Sunday"	file=.Sun;;
	[Mm]on*)	arg1="" arg2=" for Monday"	file=.Mon;;
	[Tt]ue*)	arg1="" arg2=" for Tuesday"	file=.Tue;;
	[Ww]ed*)	arg1="" arg2=" for Wednesday"	file=.Wed;;
	[Tt]hu*)	arg1="" arg2=" for Thursday"	file=.Thu;;
	[Ff]ri*)	arg1="" arg2=" for Friday"	file=.Fri;;
	[Ss]at*)	arg1="" arg2=" for Saturday"	file=.Sat;;
	[Jj]an*)	arg1="" arg2=" for January"	file=.Jan;;
	[Ff]eb*)	arg1="" arg2=" for February"	file=.Feb;;
	[Mm]ar*)	arg1="" arg2=" for March"	file=.Mar;;
	[Aa]pr*)	arg1="" arg2=" for April"	file=.Apr;;
	[Mm]ay)		arg1="" arg2=" for May"		file=.May;;
	[Jj]un*)	arg1="" arg2=" for June"	file=.Jun;;
	[Jj]ul*)	arg1="" arg2=" for July"	file=.Jul;;
	[Aa]ug*)	arg1="" arg2=" for August"	file=.Aug;;
	[Ss]ep*)	arg1="" arg2=" for September"	file=.Sep;;
	[Oo]ct*)	arg1="" arg2=" for October"	file=.Oct;;
	[Nn]ov*)	arg1="" arg2=" for November"	file=.Nov;;
	[Dd]ec*)	arg1="" arg2=" for December"	file=.Dec;;
	19[0-9][0-9])	arg1="" arg2=" for $1"		file=.$1;;
	1|21|31)	arg1="" arg2=" for the $1st"	file=.$1;;
	2|22)		arg1="" arg2=" for the $1nd"	file=.$1;;
	3|23)		arg1="" arg2=" for the $1rd"	file=.$1;;
	[4-9]|[123][0-9])
			arg1="" arg2=" for the $1th"	file=.$1;;
	wk[1-6])	arg1=" $1" arg2=""		file=.$1;;
	[Yy]es*)	arg1="" arg2=" for yesterday"	file=.yesterday;;
	[Tt]od*)	arg1="" arg2=" for today"	file=TODAY;;
	*)		echo "statsprint: Unknown arg: '$1'"; exit 1;;
	esac
	;;
2)	case $1 in
	wk|week)	;;
	*)		echo "$Usage"; exit 1;;
	esac
	case $1 in
	[1-6])		arg1="" arg2=" for week $2"	file=.wk$2;;
	*)		echo "$Usage"; exit 1;;
	esac
	;;
*)	echo "$Usage"; exit 1;;
esac

#
# default directories (if not explicitly set)
#
: ${SPOOLDIR=/usr/spool/ACSnet}
: ${LIBDIR=$SPOOLDIR/_lib}
: ${STATSDIR=$SPOOLDIR/_stats}

#
# misc shorthands
#
A=$LIBDIR/statsprint.awk

cd $STATSDIR

if [ "$file" = TODAY ]; then
	if [ ! -r Accumulated ]; then
		echo "statsprint: No$arg1 statistics available$arg2"; exit 1
	fi
	awk -F: -f $A Accumulated
	exit $?
fi

if [ ! -r Summary$file ]; then
	echo "statsprint: No$arg1 statistics available$arg2"; exit 1
fi

awk -F: -f $A Summary$file
