.ds xL AFUtillib \- C Language AF Utilities
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
.tm \\n%:\\$1:\\$2:\\$3
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de PN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AFTonePair 3 "Release 1" "AF Version 3" 
.SH NAME
\fBAFTonePair\fP \- generate a ULAW tone pair
.SH SYNTAX
\fB#include <AF/AFUtils.h>\fP
.LP
extern void \fBAFTonePair\fP(double \fIf1\fP, double \fIdBgain1\fP, 
.br
                                        double \fIf2\fP, double \fIdBgain2\fP, 
.br
                                        int \fIgainramp\fP, 
.br
                                        unsigned char \fI*buffer\fP, int \fIlength\fP);
.LP
.SH DESCRIPTION
.PN AFTonePair
is a subroutine which is suitable for generating ringback, busy,
dialtones, and other telecommunications sounds represented by
pairs of tones at given frequencies and power levels.
.SH ARGUMENTS
.IP \fIf1 and f2\fP
are the frequencies of the two tones.  The sample rate is known to
be 8000 Hz, so the tone frequencies must be in the range 0-4000Hz.
.IP \fIdBgain1 and dBgain2\fP
are the power levels of the two tones.  These are values relative to
"0 dBm" or the digital milliwatt, which in turn is defined to be 3.16 dB
below the digital clipping level, where signals distort.
.IP \fIgainramp\fP
is the number of samples over which the tones reach their full amplitude.
At the beginning of the block, the signal will ramp linearly up to full
power over so many samples.  This tends to make the signals sound cleaner
and reduces frequency splatter.  At the end of the block, the signals
will ramp down to silence over the same period.
.IP \fIbuffer\fP
is a pointer to the signal buffer that will be filled in by AFTonePair.
.IP \fIlength\fP
is the length of the block desired.
.SH EXAMPLES
Typical usage is:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
unsigned char busytone[4000];
/* fill block with 1/2 second of a busy signal */
AFTonePair(480.0, -12.0, 620.0, -12.0, 24, busytone, 4000);
/* the parameters for other tones are:
 *  ringing  440, -19, 480, -19
 *  busy     480, -12, 620, -12
 *  dialtone 350, -13, 440, -13
 */
.De
.SH "SEE ALSO"
AFDialPhone(3)
\.SH BUGS
If you encounter a \fBreproducible\fP bug, please 
submit a problem report to (af-bugs@crl.dec.com).
.SH COPYRIGHT
Copyright 1990-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Larry Stewart, 
Digital Cambridge Research Lab
