#
/*
 */

#include "../param.h"
#include "../user.h"
#include "../filsys.h"
#include "../file.h"
#include "../conf.h"
#include "../inode.h"
#include "../reg.h"

/*
 * Convert a user supplied file descriptor into a pointer
 * to a file structure, being sure to check it's range.
 * errors --
 * EBADF: The user doesn't have that file handle open
 *	  or the file handle is garbage.
 */
getf(f)
{
	register *fp, rf;

	rf = f;
/* protocol change... double file table size below ##bsb 3-27-76 */
	if(rf >= 0 && rf < NOFILE+NOFILE)
		if((fp = u.u_ofile[rf]) != NULL)
			return(fp);
	u.u_error = EBADF;
	return(NULL);
}

/*
 * Internal form of close.
 * Decrement reference count on
 * file structure and call closei
 * on last closef.
 * Also make sure the pipe protocol
 * does not constipate.
 */
closef(fp)
int *fp;
{
	register *rfp, *ip;

	rfp = fp;
	if(rfp->f_flag&FPIPE) {
		ip = rfp->f_inode;
		ip->i_mode =& ~(IREAD|IWRITE);
		wakeup(ip+1);
		wakeup(ip+2);
	}
	if(rfp->f_count <= 1)
		closei(rfp->f_inode, rfp->f_flag&FWRITE);
	rfp->f_count--;
}

/*
 * Decrement reference count on an
 * inode due to the removal of a
 * referencing file structure.
 * On the last closei, switchout
 * to the close entry point of special
 * device handler.
 * Note that the handler gets called
 * on every open and only on the last
 * close.
 */
closei(ip, rw)
int *ip;
{
	register char *rip;
	register dev, maj;

	rip = ip;
	dev = rip->i_addr[0];
	maj = rip->i_addr[0].d_major;
	if(rip->i_count <= 1){
		rip=rip->i_mode&IFMT;
		if(rip==IFCHR)
			(*cdevsw[maj].d_close)(dev, rw);
		else {
			if(rip==IFBLK)
				(*bdevsw[maj].d_close)(dev, rw);
		}
	}
	ilkput(ip);	/* improve inode locking ##stt 1/17/77 */
}

/*
 * openi called to allow handler of special files
 * to initialize and validate before actual IO.
 * Called on all sorts of opens and also on mount.
 * errors --
 * ENXIO: The device major is garbage.
 */
openi(ip, rw)
int *ip;
{
	register char *rip;
	register dev, maj;

	rip = ip;
	dev = rip->i_addr[0];
	maj = rip->i_addr[0].d_major;
	rip =rip->i_mode&IFMT;
	if(rip == IFCHR){
		if(maj >= nchrdev)
			goto bad;
		(*cdevsw[maj].d_open)(dev, rw);
	} else {
		if(rip == IFBLK){
			if(maj >= nblkdev)
				goto bad;
			(*bdevsw[maj].d_open)(dev, rw);
		}
	}
	return;

bad:
	u.u_error = ENXIO;
}

/*
 * Check mode permission on inode pointer.
 * Mode is READ, WRITE or EXEC.
 * In the case of a WRITE, the inode
 * can't point to a read-only file
 * system or a sharable text segment.
 * The super user is granted all
 * permissions except for EXEC where
 * at least one of the EXEC bits must
 * be on.
 * errors --
 * EROFS: Attempted to write on a read-only file system.
 * ETXTBSY: Attempted to write on a sharable text segment.
 * EACCES: No permission to do what was requested.
 */
access(aip, mode)
int *aip;
{
	register *ip, m, uid;

	ip = aip;
/**rjb**/	uid = ip->i_uid;
/**rjb**/	uid =<< 8;
/**rjb**/	uid =| ip->i_gid;
	m = mode;
	if(m == IWRITE) {
		if(getfs(ip->i_dev)->s_ronly != 0) {
			u.u_error = EROFS;
			return(1);
		}
		if(ip->i_flag & ITEXT) {
			u.u_error = ETXTBSY;
			return(1);
		}
	}
	if(u.u_uid == 0) {
		if(m != IEXEC || ip->i_mode&(IEXEC | IEXEC>>6))
			return(0);
	} else {
		if(u.u_uid != uid) m =>> 6;
		if (ip->i_mode & m)
			return(0);
	}
	u.u_error = EACCES;
	return(1);
}

/*
 * Look up a pathname and test if
 * the resultant inode is owned by the
 * current user.
 * If not, try for super-user.
 * If permission is granted,
 * return inode pointer.
 * Called from sys4.c - chmod(), chown()
 */
owner()
{
	register struct inode *ip;
	register int uid;
	extern uchar();

	if ((ip = namei(uchar, 0)) != NULL) {
/**rjb**/	uid = ip->i_uid;
/**rjb**/	uid =<< 8;
/**rjb**/	uid =| ip->i_gid;
		if(u.u_uid == uid || suser())
			return(ip);
		iput(ip);
	}
	return(NULL);
}

/*
 * Test if the current user is the
 * super user.
 * errors --
 * EPERM: The user isn't su and therefore can't do what he wanted to.
 */
suser()
{

	if(u.u_uid == 0)
		return(1);
	u.u_error = EPERM;
	return(0);
}

/*
 * Allocate a user file descriptor.
 * Called from falloc.
 * errors --
 * EMFILE: The users file descriptor table is full.
 */
ufalloc()
{
	register i;

	for (i=0; i<NOFILE; i++)
		if (u.u_ofile[i] == NULL) {
			u.u_ar0[R0] = i;
			return(i);
		}
	u.u_error = EMFILE;
	return(-1);
}

/*
 * Allocate a user file descriptor
 * and a file structure.
 * Initialize the descriptor
 * to point at the file structure.
 * messages --
 * No file -> If there are no available	file structures.
 * errors --
 * ENFILE: The system file table is full (increase NFILE).
 */
falloc()
{
	register struct file *fp;
	register i;

	if ((i = ufalloc()) >= 0) {
		for (fp = &file[0]; fp < &file[NFILE]; fp++)
			if (fp->f_count==0) {
				u.u_ofile[i] = fp;
				fp->f_count++;
				fp->f_offset[0] = 0;
				fp->f_offset[1] = 0;
				return(fp);
			}
		log(LOG_LOG, "No file\n");
		u.u_error = ENFILE;
	}
	return(NULL);
}
