
/* this program takes a dos tape, and
extracts  files from tape, leaving them on
the current directory

	compile
	cc -O -n dos.c

	forrest howard, 8-75

	modifications by john burruss, 8-75:
		syntax is
	% dos # [-]
		# is tape drive number (/dev/tap#)

		optional third arg means-- gimme only listing of filenames on
		the tape, don't extract any files

		the program does a 'dsw' style interactive extraction:
	 it types
		extract file.ext ?
	and the user replys "x"  for exit, "y" for extract, and
	anything else for skip file.
*/

char	*radtab "?abcdefghijklmnopqrstuvwxyz$./01234567890";

struct	ufds {
	int	fname[3];
	int	crdate;
	int	freebyte;
	int	startblock;
	int	length;
	int	lastblock;
	int	Junk;
}	ufd[56];


int	fi;
int	fo;

int	buf[256];
char	*tape	"/dev/tap ";
char	*tapnum;
int lflag, aflag;

main(argc,argv)
int	argc;
char	*argv[];
{
	register	i;
	int	foo,fie;

	if (argc < 2) error("use: dostape # [-a][-l]");
	tapnum = tape + 8;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') switch(argv[i][1]) {
		case 'l':
			lflag++;
			continue;
		case 'a':
			aflag++;
			continue;
		default:
			type(2, argv[i]);
			error("unknown switch");
		}
		*tapnum = argv[i][0];
	}
	if ((fi = open(tape,0)) < 0)
		exit(printf("can't open %s\n",tape));

	/* get ptr to ufd */

	seek(fi,0100,3);
	read(fi,&foo,2);
	seek(fi,foo,3);
	seek(fi,4,1);
	read(fi,&foo,2);
	read(fi,&fie,2);
	if((2 *fie) != sizeof ufd[0]) 
		exit(printf("ufd size mismatch\n"));

	seek(fi,foo,3);
	read(fi,&foo,2);
	read(fi,&ufd[0],28 * (sizeof ufd[0]));
	seek(fi,foo,3);
	seek(fi,2,1);
	read(fi,&ufd[28], 28 * (sizeof ufd[0]));
	/* ok-- now lets see about files */
	for( i=0; i < 56; i++) dofile(i);
	seek(fi,0,0);
	close(fi);
}

dofile(number)
{
	register struct	ufds *dir;
	char		c;
	register	i,j;

	dir = &ufd[number];
	if(getname(dir->fname[0],dir->fname[1],dir->fname[2]))
			return;
	if (lflag) {
		printf("%s\n",buf);
		return;
		}
	if (!aflag) {
		printf("extract %s ?",buf);
		c = getchar();
		if (c == 'x') exit(printf("exit\n"));
		if (c != 'y') return;
		getchar();
	}
	if ((fo =creat(buf,0604)) < 0)
		return(printf("can't extract %s\n",buf));
	if(dir->crdate < 0) contigf(dir); else linkfile(dir);
	close(fo);
}


contigfil(dir)
struct	ufds *dir;
{
	register i,j;
	register struct ufds *d;

	d = dir;
	i = d->length;
	seek(fi,d->startblock,3);
	while(--i){
		read(fi,buf,512);
		write(fo,buf,512);
	}
	j = read(fi,buf,(d->freebyte? d->freebyte-1:512));
	write(fo,buf,j);
}


linkfile(dir)
struct	ufds *dir;
{
	register i,j;
	register struct ufds *d;

	d = dir;
	i = d->startblock;
	while(i != 0) {
		if(i > 0) {
			seek(fi,i,3);
			read(fi,buf,512);
			} else {
			i= -i;
			seek(fi,i,3);
			readr();
		}
		write(fo, &buf[1], i!=d->lastblock || d->freebyte==0?
		    510: d->freebyte-1);
		i = *buf;
		if (i > 576 || i < -576)
			return(printf("block %o on current file bad\n", i));
	}
}

getname(i,j,k)
{
	register char	*cp;
	if( i== 0 && j==0 && k==0) return(1);
	cp = unpak(i,buf);
	cp = unpak(j,cp);
	if(k) {
		*cp++ = '.';
		cp = unpak(k,cp);
	}
	*cp++ = 0;
	return(0);
}

unpak(i,ccp)
char	*ccp;
{
	register char	*cp;
	register	d,e;
	int	c;
	extern	ldivr;
	cp = ccp;
	d = ldiv(0,i,40);
	e = ldivr;
	c = ldiv(0,d,40);
	d = ldivr;
	if (c) *cp++ = radtab[c];
	if (d) *cp++ = radtab[d];
	if (e) *cp++ = radtab[e];
	return(cp);
}

readr()
{
	int	buff[256];
	register int	*cs,*cd;
	register	i;
	read(fi,buff,512) ;
	cd = &buf[256];
	cs = buff;
	i = 257;
	while(--i) *--cd = *cs++;
}
