#
/*
 * system calls added at Mathematisch Centrum, Amsterdam.
 */

#include	"../param.h"
#include	"../user.h"
#include	"../reg.h"
#include	"../proc.h"

/* change nicety of a process - returns previous value */
setnice(){
	register struct proc *p;
	register a,n;

	if(a = u.u_ar0[R0]){
		for(p = &proc[0]; p < &proc[NPROC]; p++){
			if(p->p_pid != a) continue;
			if(u.u_uid != p->p_uid && !suser())return;
			n = u.u_arg[0];
			if(n > 20)
				n = 20;
			if(n < 0 && !suser())
				n = 0;
			u.u_ar0[R0] = p->p_nice;
			p->p_nice = n;
			return;
		}
	}
	u.u_error = ESRCH;
}
