#
/*
 * nijmegen, h.j. thomassen, june 1976.
 * UNIX document 16
 */
#define	blksiz 512
/* be very careful in changing this block-size.
   the seek-call has as its argument a type-3 thing,
   i.e. the caller supplied blocknumber gets
   mapped directly upon physical block size.
   Don't change that without remembering that
   a seek offset in bytes instead of in phys. blocks
   will run out of the integer-range for files
   over 200 (8) blocks long
*/


main (argc,argv)
	char	**argv;
{
int	fildes,fildeso;
char	buffer[blksiz];

	if ((argc != 3) && (argc != 4)) {
 		printf ("arg count\n");
		exit(0); }
	if ( ( fildes = open (argv[--argc] , 0)) < 0) {
		printf ("open error on %s\n", argv[argc]);
		exit(0); }
	if ( seek (fildes, (atoio(argv[--argc])), 3) < 0) {
		printf ("seek error on block %s\n", argv[argc]);
		exit(0); }
	if ( read (fildes, buffer, blksiz) != blksiz) {
		printf ("read error, %d\n", blksiz);
		exit(0); }
	if (--argc)	{
		fildeso = 1;
	} else  {
		if ((fildeso=creat ("./zapblock\0",0666)) < 0) {
			printf ("can't create zapblock\n");
			exit(0); }
	}
	if (write (fildeso, buffer, blksiz) < 0 ) {
		printf ("can't write on output\n");
		exit(0); }
}

atoio(ap)
char *ap;
{
	register n,zero;
	register char *p;
	int f;

	p=ap; n=0; f=0; zero= '0';

loop:	while (*p == ' ' || *p == '	')
		p++;
	if (*p == '-') {
		f++; p++; goto loop; }
	while ( *p >= zero && *p <= '7')
		n= n*8 + *p++ - zero;
	if (( *p == '8' ) || ( *p == '9' ) ) {
		printf (" octal block number required\n");
		exit(0); }
	if (f) n = -n;
	return(n);
}
