#
#define wmax 511
/*
	trunc [-l] [-wn] [-c] [-b]
	-l to suppress removing trailing blanks
	-wn to reset the truncation length to n
	-c to suppress removing carriage returns
	-b (implies -c) to insert carr.ret before linefeed

	H.J.Thomassen, Univ.Nijmegen,Neth; 1976.
*/
int	llen	wmax;
int	lflag	0;
int	cflag	0;
int	bflag	0;

main(argc, argv)
char **argv;
{

int	ni, no, a, temp;
char	ibuf[512] ;
char    buf[2*wmax+6] ;
/* this buffer has room for 2 lines, 2 newlines, 2 carr. returns and " a"
   at the beginning to facilitate easy removal of trailing blanks */
register char *pi, *po, c;

	buf[1]='a';
	while	(--argc )	{
			if (**++argv == '-') {
			   if (*++argv[0] == 'l') {
			      lflag++;
			   }
			   if (*argv[0] == 'w') {
			      if ((llen=getn(++*argv)) >wmax) {
			        write (2, "length too long\n", 16);
				exit(0);
			      }
			   }
			   if (*argv[0] == 'c') {
			      cflag++;
			   }
			   if (*argv[0] == 'b') {
			      bflag++; cflag++;
			   }
			}
	}

	while ((ni = read (0, ibuf, 512)) > 0) {
		temp = buf+2+a; /* pointer to where new data will go */
		pi = ibuf; po = temp; no=0;
		while (( pi - ni ) < ibuf) {
			c = *pi++;
			if (( c != '\n' )&&( a < llen)) {
			   *po++ = c; a++; /* accept for output */
			}
			if ( c == '\n') {
			   if (cflag == 0) { /* remove preceding carret */
			      if (*--po == '\r') --a; else po++;
			   }
			   if (lflag == 0) { /* remove trailing blanks */
			      while (*--po == ' ') --a;
			      po++;
			   }
			   if (bflag != 0) { /* insert carret. before linefeed */
			      if (*--po != '\r' ) {
				 po++; *po++ = '\r'; a++;
			      }
		           }
			   *po++ = c; no =+ (++a); a = 0;
			}
		}
		if ( no != write (1, buf+2, no)) write (2, "write error\n", 12);
		/* the last line, which hasn't been terminated yet, has not been
		   written. move it to the beginning of the buffer */
		temp = a; pi = buf+2; po = po - a;
		while (temp--) *pi++ = *po++;
	}
	if (ni < 0) write (2, "read error\n", 11);
}

getn (ap) /* get numerical value of -w argument */
char *ap;
{
	register int n, c;
	register char *p;

	p = ap; n=0;
	while ((c = *p++) >= '0' && c <= '9')
		n = n*10 + c - '0';
	return(n);
}
