#

/*
 *	links [filsys]
 *
 *	Find linked non-directory files on filsys.
 *	Default is /dev/rrk0.
 *
 *	Written 5/77 by Steve Eisen for CUNY/UCC.
 */

#define BUFLEN	64
#define DELIM	'\t'
#define EOF	'\0'

int	filep[2];
char	inbuf[BUFLEN];
char	str[BUFLEN];
char	deflt[]	"/dev/rrk0";

main(argc, argv)
char *argv[];  {
	register char *filsys;
	register i, count;
	int filin;

	switch(argc)  {
		case 1:
			filsys = deflt;
			break;

		case 2:
			filsys = argv[1];
			break;

		default:
			printf("Arg count\n");
			exit();
	}
	pipe(filep);
	if (fork() == 0)  {
		close(1);
		dup(filep[1]);
		close(filep[0]);
		close(filep[1]);
		execl("/bin/ncheck", "ncheck", filsys, 0);
		close(1);
		dup(2);
		printf("No ncheck\n");
		exit();
	}
	filin = filep[0];
	close(filep[1]);
	pipe(filep);
	if (fork() == 0)  {
		close(0);
		dup(filin);
		close(1);
		dup(filep[1]);
		close(filin);
		close(filep[0]);
		close(filep[1]);
		execl("/bin/sort", "sort", "-n", 0);
		close(1);
		dup(2);
		printf("No sort\n");
		exit();
	}
	close(0);
	dup(filep[0]);
	close(filep[0]);
	close(filep[1]);
	close(filin);
/*
 *  pipe setup completed
 */
	if (getline())  {
		while (wait() != -1);
		exit();
	}
	for (i=0; i<BUFLEN; i++)
		str[i] = inbuf[i];
	count = 0;
	while (getline() == 0)  {
		if (same(str, inbuf))  {
			if (count == 0)
				printf("\n%s\n", str);
			printf("%s\n", inbuf);
			++count;
		}
		else if (count)
			count = 0;
		for (i=0; i<BUFLEN; i++)
			str[i] = inbuf[i];
	}
	putchar('\n');
}

getline()  {
	register i;

	i = 0;
	while ((inbuf[i] = getchar()) != '\n')  {
		if (inbuf[i] == EOF) return(-1);
		if (i < BUFLEN-1) i++;
	}
	inbuf[i] = '\0';
	return(0);
}

same(str1, str2)
char *str1, *str2;  {
	register i;
	for (i=0; i<4; i++)  {
		if (str1[i] != str2[i]) return(0);
		if (str1[i] == DELIM) return(1);
	}
	return(1);
}
