#
/*
**	MAN -- Print one or more sections of the UNIX manual
**
**	Compile: cc -O -n man.c 
**		Copyright (c) 1976 P. Langston,
*				   Commercial Union Leasing
*				   645 Madison Ave
*				   N.Y.C., N.Y.
*/
#define	MAXSECT	9

char	filename[40], sbuf[36];

main(argc,argv)
char **argv;
{
	register char *arg, *sect_spec;

	if (argc < 2) {
		write(2, "Usage: man [ sect # ] title [ title ... ]\n", 42);
		exit(-1);
	}
	arg = *++argv;
	if (*arg > '0' && *arg <= '9') {
		sect_spec = *argv++;
		--argc;
	}
	else
		sect_spec = 0;
	while (--argc) {
		arg = *argv++;
		if (sect_spec)
			make_filename(sect_spec, arg);
		else
			find_filename(arg);
		if (stat(filename, sbuf) == -1) {
			oop(arg, sect_spec);
			continue;
		}
		wait();
		if (fork() == 0) {
			execl("/usr/bin/nroff", "nroff", "-s",
			 "/usr/doc/man/man0/term.mac", filename, 0);
			write(2, "Execl of nroff failed\n", 23);
			exit(-1);
		}
	}
	wait();
}

make_filename(sect, title)
char sect, *title;
{
	register char *cp;

	cp = copy("/usr/doc/man/man", filename);
	cp = copy(sect, cp);
	*cp++ = '/';
	cp = copy(title, cp);
	*cp++ = '.';
	cp = copy(sect, cp);
}

find_filename(title)
char *title;
{
	register int i;
	char section[4];

	for (i=1; i<MAXSECT; i++) {
		copy(itoa(i), section);
		make_filename(section, title);
		if (stat(filename, sbuf) != -1)
			return;
	}
}

oop(title, section)
char *title, *section;
{
	register char *cp;
	char message[80];

	cp = copy("Can't find ", message);
	cp = copy(title, cp);
	if (section) {
		cp = copy(" in section ", cp);
		cp = copy(section, cp);
	} else
		cp = copy(" in the manual", cp);
	cp = copy(".\n", cp);
	write(2, message, cp-message);
}
copy(from,to)
char *from, *to;
{
	register char *f, *t;

	f = from;
	t = to;
	while (*t++ = *f++);
	return(--t);
}



itoa(num)
{
	register char *cp;
	register int i, j;
	static char buf[8];
	int lzs;

	cp = buf;
	if (num < 0) {
		*cp++ = '-';
		num = -num;
	}
	lzs = 0;
	for (i = 10000; i > 0; i =/ 10 ) {
		j = num/i;
		if (j || lzs) {
			*cp++ = '0'+j;
			num =- i*j;
			lzs++;
		}
	}
	*cp = 0;
	return(buf);
}
