#

/*
 * lda - a.out to lda conversion.
 *
 *	Forrest W. Howard Jr.  2/24/74
 *	Commercial Union Leasing Co
 *	645 Madison Ave
 *	New York, NY 10022
 * 
 * use:
 *	lda foo [-]
 *	produces a foo.lda
 *
 * compile:
 *	cc -O lda.c
 */

#define MAGIC header[0]
#define TSIZE header[1]
#define DSIZE header[2]
#define BSIZE header[3]

char	ibuf[518];	/* input (getw) */
char	obuf[518];	/* used for the putc output */
char	tbuf[512];	/* used for lda storage */
char	*tbp;		/* pointer to above */
int	header[8];	/* file header */
int	lcokie;		/* file handle */
int	baseaddr;	/* baseaddress of buffer */



main(argc,argv)
char **argv;
{
	register int *ip;

	if(argc < 2) {
		printf("Usage: lda file [-]\n");
		return(1);
	}
	++argv;
	if(fopen(stickext(*argv, "out", 0), ibuf) == -1) {
		printf("%s: cannot open\n", *argv);
		return(1);
	}
	for(ip = &header[0]; ip < &header[8]; )
		*ip++ = getw(ibuf);
	if(MAGIC != 0407 && MAGIC != 0410) {
		printf("File not proper format\n");
		return(1);
	}
	if(fcreat(stickext(*argv, "lda", -1),  obuf) == -1) {
		printf("Cannot create output\n");
		return(1);
	}
	chmod(stickext(*argv, "obj", -1), 0604);
	putc(0, obuf);			/* initial zero's required */

	tbp = tbuf;
	baseaddr = 0;
	process(TSIZE, 0);		/* do text */
	if(MAGIC == 0410) {
		baseaddr=+ 017777;
		baseaddr=& ~017777;
	}
	process(DSIZE, 0);		/* do data */
	if (argc == 2)
		process(BSIZE, 1);	/* do bss, insure zeros */

	putw(1, obuf);			/* start block */
	putw(6, obuf);			/* byte count of 6 */
	putw(0, obuf);			/* start addr */
	putc(-7, obuf);			/* checksum */


	fflush(obuf);
	close(ibuf[0]);
	close(obuf[0]);
	return(0);
}

process(size, zflg)
{
	register nbytes, bsize;

	while(size) {
		nbytes = 64;
		if(size < nbytes)
			nbytes = size;
		bsize = nbytes;
		while(nbytes) {
			nbytes =- 2;
			if (zflg)
				stuff2(0);
			else
				stuff2(getw(ibuf));
		}
		dump();
		size =- bsize;
		baseaddr =+ bsize;
	}
}

stuff2(word)
{
	struct { char lobyte; char hibyte; };

	if (tbp > &tbuf[512]) goto bad;
	*tbp++ = word.lobyte;
	if (tbp > &tbuf[512]) {
bad:		printf("Block too long in address block %o\n", baseaddr);
		return;
	}
	*tbp++ = word.hibyte;
}

dump()
{
	register char *c;
	register int bc, cksum;

	bc = tbp - tbuf;
	putw(01, obuf);			/* 01 = header */
	putw(6 + bc, obuf);		/* byte count */
	putw(baseaddr, obuf);		/* load address */
	cksum = 7 + bc + (bc>>8) + baseaddr + (baseaddr>>8);
	c = tbuf;
	while(c < tbp) {
		cksum =+ *c;
		putc(*c++, obuf);	/* info */
	}
	putc(-(cksum & 0377), obuf);	/* checksum */
	tbp = tbuf;
}

stickext(s, ext, f)
char *s, *ext;
{
	static name[134];
	char junk[36];
	register dot;
	register char *cs, *cd;

	cs = s;
	dot = 0;	/* is set to 0 when / seen; set to 1 when dot seen */
	cd = name;
	if(! *cs) {
		printf("Internally saw null file name\n");
		exit(1);
	}
	do {
		if(*cs == '/')	 dot = 0;
		if(*cs == '.')   dot = 1;
		*cd++ = *cs;
		if(cd > &name[128]) {
			printf("File name to long\n");
			exit(1);
		}
	} while (*cs++);
	--cd;
	if(dot && f < 0) {
		do {
			dot = *cd;
			*cd-- = 0;
		} while(dot != '.');
		dot=0;
		cd++;
	}
	if(dot) return(s);	 /* name had dot-- don't append another */
	cs = cd;
	*cd++ = '.';
	while(*cd++ = *ext++);
	if((! f) && (stat(name, junk) == -1))
		*cs = 0;
	return(name);
}

