#include	"ded.h"
/* first directory editor file ("ded") */
int	magic	0175757;	/* number put at end of dfile entries */
char	*dfile	"dir.d";
struct	dir *dirp &end;
struct	dir *rdirp &end;
int	a	&end;

	/*
	 * Main loop of the editor.  First sets a return
	 * for restarting after an outside function.
	 * Upon return from such a diversion the first page
	 * to be displayed is returned from setexit().
	 * Pointers in dfile space are zeroed and core is
	 * freed.  If dfile doesn't exist it is created
	 * and initialized.  The current directory is opened and
	 * it and dfile are read in; the directory entries are
	 * sorted and checked against the dfile entries, which
	 * are pushed and deleted and generally fixed up as
	 * necessary.  dfile entries are then moved up and
	 * end of core is reset to end of the entries.
	 * Then we look at names surrounding source files for
	 * possible matching object files, and get
	 * number of extra compile flags.
	 * List is called (which in turn calls edit) to do
	 * all of the real work.  Everything is saved in the
	 * dfile on return from list and things exit cleanly.
	 */
main() {
	int dcompar(),compar(),retpage;
	if(retpage = setexit()) close(df);
	else retpage = 1;
	a = dirp = rdirp = &end;
	fdirp = rfdirp = 0;
	nent = maxp =0;
	brk(&end);
	if((df = open(dfile,2))<0) {
		init();
		goto current;
	}
	gdir();
/*	fstat(d,&statb);
	fstat(df,&fdstatb);*/
	readin(&retpage);
	qsort(&end,(dirp-&end),sizeof *dirp,dcompar);
		/* sort directory entries.
		 * dfile was created sorted.  */
	compar();
	xfer(&end, dirp.inm,  fdirp.inm - dirp.inm );
	a = a + fdirp.inm - dirp.inm;
	surround(&end, a);
	getflgs();
current:
	brk(a);
	close(d);
	d = &end;
	nent = (a-d)/sizeof dfent - 2;	/* -2 to skip . and .. */
#ifdef DEBUG
	printf("ok\n");
	getchar();
#endif
/*	saveall(retpage);*/
	saveall(list(retpage));
	erase();
	texit();
}

	/*
	 * Write dfile entries out to dfile, followed
	 * by magic number, followed by compile flags
	 * and the page number at which to restart.
	 */
saveall(page) {
	seek(df,0,0);
	write(df,d,a-d);
	write(df,&magic,2);
	write(df,preflg,sizeof preflg);
	write(df,pstflg,sizeof pstflg);
	write(df,&page,2);
}

	/*
	 * Primitive function to compare two strings for equality.
	 */
eq(s1,s2)
char *s1,*s2; {
	register char *p1,*p2;
	p1 = s1;
	p2 = s2;
	if(*p1 == 0 || *p2 == 0)
		if(*p1 == *p2)
			return(1);
		else
			return(0);
	while(*p1++ == *p2++ && *(p1-1) != 0);
	if(*--p1 == '\0' && *--p2 == '\0')
		return(1);
	else
		return(0);
}

	/*
	 * Creates "dfile", where the editor keeps
	 * all information regarding files in the current
	 * directory.
	 */
create() {
	if((df = creat(dfile,0644)) < 0) {
		perror(dfile);
		exit();
	}
}

peek(sp)
struct fdir *sp;
{
	/* read first 8 words.  Check first word for
	 * magic number for archive (library) or object
	 * file.  if it starts with "ch", look at rest to
	 * see if it's a charset.
	 */
	int first[4];
	if(read(f,first,8) <= 0) return;
	switch(*first) {
		case 0407:
		case 0410:
		sp->type =| OBJ; /* object */
		break;

		case 0177555:
		sp->type =| ARCH; /* archive */
		break;

		case 'ch':
		if(eq(first,"charset"))
		sp->type =| CHRST; /* charset */
	}
}

readin(ret) int *ret; {
	/* when done, "&end" is starting address
	 * of directory entries, and "dirp" points to start of
	 * dfile entries.  "rfdirp" will point to end of core,
	 * when EOF or magic number is reached.
	 * After magic number is found, compile-time flags
	 * are copied from last record read from dfile.
	 * Last page shown is also read, and used if
	 * page 1 would be shown otherwise.
	 */
	register c;
	register char *cp1, *cp2;
	do {
		if(dirp+1 >= rdirp) {
			sbrk(128);
			rdirp.inm =+ 128;
		}
		c = read(d,dirp,16);
		if(dirp->inm)
			dirp++;
	} while(c == 16);

	fdirp = dirp;
	rfdirp = rdirp;

	do {
		if(fdirp+1 >= rfdirp) {
			sbrk(128);
			rfdirp.inm =+ 128;
		}
	} while(read(df,fdirp,sizeof *fdirp) == sizeof *(fdirp)
		&& (fdirp++)->inm != magic);
	cp1 = fdirp-1;
	cp1 =+ 2;	/* to step over magic number */
	cp2 = *preflg;
	for(c = 0; c < sizeof *fdirp - 2; c++)
		*cp2++ = *cp1++;
	read(df, cp2, sizeof preflg - c);
	read(df, *pstflg, sizeof pstflg);
	if(*ret == 1) {
		read(df, ret, 2);
	}
#ifdef DEBUG
	printf("%s,%s,%s\n",(fdirp-3)->fname,(fdirp-2)->fname,(fdirp-1)->fname);
#endif
}

dcompar(ap1,ap2)
int ap1,ap2; {
	/*
	 * Routine called by "qsort" library function to
	 * lexically compare two file names.
	 */
	register p1,p2;
	register i;
	p1=ap1;
	p2=ap2;
	i = 0;
	while(p1->name[i] == p2->name[i] && i++ < 15);
	if(i == 15) return(0);
	return(-2*(p1->name[i] < p2->name[i]) + 1);
}

compar() {
	/* compare entries between directory
	 * and dfile.  If different, look to
	 * see whether there are extra entries
	 * in dfile (infdir) or in the directory (insert).
	 */
	register struct dir *sdir;
	register struct fdir *fsdir;
	extern struct dir end;
	fsdir = dirp.inm - sizeof *fsdir;
	sdir = &end-1;
	while (++sdir<dirp) {
		if(++fsdir >= rfdirp) {
			sbrk(128);
			rfdirp.inm =+ 128;
		}
		if(eq(sdir->name,fsdir->fname)) {
			continue;
		}
		else {
#ifdef DEBUG
			printf("diff -- %s: %s, %s, %s, %s\n",sdir->name,
			    (fsdir-2)->fname,(fsdir-1)->fname,fsdir->fname,(fsdir+1)->fname);
#endif
			if(infdir(sdir,fsdir))
				continue;
			else {
				insert(sdir,fsdir);
			}
		}
	}
	fdirp = fsdir+1;
}

infdir(ad,fd)
struct	dir *ad;
struct	fdir *fd; {
	/* look down dfile entries for the current directory
	 * entry.  If found, move dfile entries up by
	 * "occur" entries.  return 1 if found, 0 otherwise.
	 */
	register struct dir *sdir;
	register struct fdir *fsdir;
	register occur;
	sdir = ad;
	fsdir = fd;
	occur = 1;
	while(++fsdir < fdirp) {
		if(eq(fsdir->fname,sdir->name)) {
#ifdef DEBUG
			printf("up -- %s\n",fsdir->fname);
#endif
			moveup(fsdir-1,occur);
			return(1);
		}
		else
			occur++;
	}
	return(0);
}

moveup(fd,n)
struct	fdir *fd; {
	/*
	 * Move up dfile entries by n slots, beginning at
	 * position fd.
	 */
	register struct fdir *fsdir;
	register struct fdir *fend;
	register i;
	i = n;
	fsdir = fd;
	fend = fdirp;
	while(++fsdir < fend) {
		(fsdir-i)->flags = fsdir->flags;
		(fsdir-i)->type = fsdir->type;
		copy((fsdir-i)->fname,fsdir->fname,16);
		copy((fsdir-i)->mesg,fsdir->mesg,12);
	}
	fdirp =- i;	/* decrement end-of-dfile-entries pointer */
}

copy(ap1,ap2,num)
char *ap1,*ap2; int num; {
	/*
	 * Primitive character-oriented copy routine.
	 */
	register char *p1,*p2;
	register int i;
	i = 0;
	p1 = ap1;
	p2 = ap2;
	while(i++ < num)
		*p1++ = *p2++;
}

insert(d1,d2)
struct	dir *d1;
struct	fdir *d2; {
	/*
	 * move down dfile entries.  Copy in new name, type 0
	 * so "getype" will work properly.  No flags yet,
	 * no message.
	 */
	register struct dir *sdir;
	register struct fdir *fsdir;
	register i;
#ifdef DEBUG
	printf("dn -- %s\n",d2->name);
#endif
	i = 0;
	sdir = d1;
	fsdir = d2;
	movedn(fsdir);
	copy(fsdir->fname,sdir->name,16);
	fsdir->type = 0;
	getype(fsdir);
	fsdir->flags = 0;
	do fsdir->mesg[i] = 0; while(++i < 12);
}

movedn(fd)
struct	fdir *fd; {
	/*
	 * Make a new slot in dfile entries by moving
	 * everything down one position starting at fd.
	 */
	register struct fdir *fsdir;
	register struct fdir *rf;
	if(++fdirp >= rfdirp) {
		sbrk(128);
		rfdirp.inm =+ 128;
	}
	fsdir = fdirp - 1;
	rf = fd;
	while(--fsdir >= rf) {
		(fsdir+1)->flags = fsdir->flags;
		(fsdir+1)->type = fsdir->type;
		copy((fsdir+1)->fname,fsdir->fname,16);
		copy((fsdir+1)->mesg,fsdir->mesg,12);
	}
}

init() {
	/* make new dir.d file.  Read directory entry, copy
	 * to dfile space (kludge) if ino is not zero (entry
	 * is current). Sort entries and write new file with
	 * magic stopping point.  set break pointer to end
	 * of entries.
	 */
	extern struct fdir end;
	create();
	gdir();
	df = open(dfile,2);
	erase();
	at(2520); printf("Initializing index file...");
	fdirp = &end;
	while(read(d,&dirent,16) == 16) {
		if(dirent.inm > 0) {
			if(fdirp+1 >= rdirp) {
				sbrk(128);
				rdirp.inm =+ 128;
			}
			copy(fdirp->fname,dirent.name,16);
			getype(fdirp++);
			fdirp->type = 0;
		}
	}
	qsort(&end, fdirp - &end, sizeof *fdirp, dcompar);
	surround(&end, fdirp);
	a = fdirp;
}

getype(sp)
struct fdir *sp; {
	/*
	 * Look at filename for suffix of ".c" or ".s".
	 * Then if file is openable, look at first few words.
	 * If still no luck, get status for possible directory.
	 */
	register struct fdir *p;
	p = sp;
	if((f = open(p->fname,0)) > 0) {
		switch(findot(sp)) {
			case 'c':
				p->type =| C|SRC;
				break;
			case 's':
				p->type =| AS|SRC;
				break;
			default:
				peek(p);
		}
		if(!p->type) {
			fstat(f,&statb);
			if(statb.flgs & DIR)
				p->type =| DIREC;
			statb.flgs = 0;
		}
		close(f);
	}
}

findot(sp)
struct	fdir *sp; {
	/*
	 * Compare two filename suffixes; i.e. the letter
	 * after the last dot in a name.
	 */
	register char *p;
	p = sp->fname;
	while( *p++ != '\0');
	p =- 3;	/* back up over null and last char */
	if(*p == '.')
		if(*++p == 'c' || *p == 's')
			return(*p);
		else
			return(0);
}

gdir() {
	/*
	 * Open the current directory for reading.
	 */
	if((d = open(".",0))<0) {
		perror("Can't open directory");
		exit();
	}
}

xfer(base1, base2, wds)
int *base1, *base2, wds;
{
	/*
	 * Primitive word-oriented data mover.
	 */
	register int *p1, *p2, i;
	p1 = base1;
	p2 = base2;
	i = 0;
	wds =/ 2;
	while(i++ <= wds) *p1++ = *p2++;
}

surround(t,b)
struct fdir *t,*b;
{
	/* Look at object files to see whether there are
	 * surrounding source files of the same name
	 * (up to a period ".").  If so, set language type
	 * of the object file to that of the source file.
	 * First and last entries are special-cased so as
	 * not to look outside the table.
	 */
	register struct fdir *fsdir;
	fsdir = t;
	if(fsdir->type &  OBJ && findot(fsdir+1) == 's'
	    && name(fsdir->fname,(fsdir+1)->fname))
		fsdir->type =| AS;
	fsdir = b;
	if(fsdir->type & OBJ && findot(fsdir-1) == 'c'
	    && name(fsdir->fname,(fsdir-1)->fname))
		fsdir->type =| C;
	for(fsdir = t+1; fsdir < b; fsdir++) {
		if(fsdir->type & OBJ) {
			if(findot(fsdir-1) == 'c'
			    && name(fsdir->fname,(fsdir-1)->fname)) {
				fsdir->type =| C;
				continue;
			}
			if(findot(fsdir+1) == 's'
			    && name(fsdir->fname,(fsdir+1)->fname))
				fsdir->type =| AS;
		}
	}
}

getflgs() {
	/*
	 * Find out if there are extra compile flags,
	 * and how many, if so.
	 */
	register i;

	flgflg = 0;
	for(i = 0; i < NFLAGS; i++) {
		if(*preflg[i])
			flgflg++;
		if(*pstflg[i])
			flgflg++;
	}
}
