#include "/h/cinfo.h"
#include "/h/stat.h"

struct	inode	stbuf;
struct	cinfo	inf;
int	fout;
int	uid;

main(argc, argv)
char **argv;
{
	register int i;
	char *myname, *toname, *mytty, *totty;
	char buf[134];
	int exfunc();

	uid = getruid();
	if(argc < 2 || argc > 4)
		exit(type(2, "Format: talk logname [terminal]\n"));
	toname = argv[1];
	if(argc == 3)
		totty = argv[2];
	else
		totty = 0;
	if(equal("-all", toname))
		exit(type(2, "Use \"priv talkall\"\n"));
/*
 * Find the desired user (on the specified tty)
 */
	if((i = find(toname, totty)) == -1)
		exit(-1);
	totty = getcopy(cat("/dev/", ttyname(i)));
/*
 * Now find all about me
 */
	if((i = getcinfo(-1, &inf)) == -1)
		exit(type(2, "Getcinfo returned -1"));
	myname = getcopy(getlogn(inf.c_uid));
	mytty = getcopy(ttyname(i));
/*
 * Set up printf to output to the other terminal.
 */
	fout = open(totty, 1);
	if(chkacc())
		exit(0);
	signal(2, &exfunc);
	signal(3, &exfunc);
/*
 * Output messages to him and me.
 */
	if(uid)
		printf("Message from \"%s\" on %s...\n", myname, mytty);
	else
		printf("Message from the Operator (\"%s\") on %s...\n",
			myname, mytty);
	flush();
	type(1, "Communications Established...\n");
	seteuid(getruid());
	while(i = readlin(0, buf, 132)) {
		if(chkacc())
			exfunc();
		buf[i] = 0;
		if(buf[0] == '!') {
			buf[i - 1] = 0;
			subshell(&buf[1]);
		} else {
			protect(&buf);
			printf("-%s", buf);
			flush();
		}
	}
	printf("-eot\n");
	flush();
}

exfunc()
{
	printf("-eot\n");
	flush();
	type(1, "Communications broken.\n");
	exit(0);
}


find(ln, ttn)
{
	register char *np, *tp;
	register int i;
	int xuid, uidfound, uniq;

	uidfound = 0;
	np = ln;
	tp = ttn;
	if((xuid = getunum(ln)) == -1)
		return(etype("No such logname \"%s\"\n", np));
	if(tp) {
		if((i = ttynum(tp)) == -1)
			return(etype("Illegal Terminal Specified.\n"));
		getcinfo(i, &inf);
		if(xuid != inf.c_uid)
			return(etype("\"%s\" Not logged onto %s.\n", np, tp));
		else
			return(i);
	}
	for(i = 0; ; i++) {
		if(getcinfo(i, &inf) == -1)
			break;
		if(inf.c_uid == xuid) {
			uidfound++;
			uniq = i;
		}
	}
	switch(uidfound) {

	case 0:	return(etype("\"%s\" Not logged on.\n", np));

	case 1:	return(uniq);

	default: etype("\"%s\" Logged on terminals: ", np);
		for(i = 0; ; i++)
			if(getcinfo(i, &inf) == -1)
				break;
			else
				if(inf.c_uid == xuid)
					printf("%s ", ttyname(i));
		printf("\n");
		flush();
		return(-1);
	}
}


etype(a, b, c, d, e, f, g)
{
	flush();
	fout = 2;
	printf(a, b, c, d, e, f, g);
	flush();
	return(-1);
}

chkacc()
{
	if(uid) {
		fstat(fout, &stbuf);
		if((stbuf.i_mode&IEXEC) == 0) {
			type(2, "Talk Denied!\n");
			return(1);
		}
	}
	return(0);
}


protect(buf)
{
	register char *cp, c;
	static badcount;

	cp = buf;
	while(c = *cp++)
		if(c < ' ' && c != '\n' && c != '\007') {
			cp[-1] = '?';
			if(++badcount > 10) {
				type(1, "Bad Character Limit Exceeded!!!\n");
				exfunc();
			}
		}
}
