#
#include "hsh.h"

/* this file contains much of the most Harvard-dependent
 * glitches in the shell, such as 'autostart', preprompt, etc.
 * other dependencies will be found in 'chkspcl.c'
 */
inithsh(c,av)
char **av;
{
	register char **v;
	register char *np;
	register f;
	char ptem;

	signal(1,&byebye);

	/* prompt based on 16-bit uid */
	uid = geteuid();
	promp = uid? "& ": "# ";
	ptem = promp[0];

	acctf = open("/usr/adm/sha", 1);

	setintr++;
	/* prepromp prepended to sub-shell prompt */
	prepromp = '>';
	v = av + 1;
    if (c > 1)
	while ((np = *v++) != -1) {
		if (*np == 0) continue;
		if (*np == '-') {
			switch(np[1]) {
			case 'c':
				/* parse argument as command line, then exit */
				arginp = *v++;
				if (arginp == -1) eof();
				promp = 0;
				break;
			case 't':
				/* parse one line from terminal, then exit */
				onelflg = 2;
				promp = 0;
				break;
			case 'p':
				/* set prepromp to char following "-p" */
				/* if no char given, means entire prompt */
				/* is specified by following arg. */
				prepromp = np[2];
				if (prepromp == 0) {
					promp = *v++;
					if (promp == -1) break;
				}
				continue;
			case '*':
			case 'a':
				/* autostart, next arg is file name */
				np = *v++;
				if (np == -1) break;
				savinp = dup(0);	/* save fh #0 */
				close (0);
				f = open (np, 0);
				if (f < 0 || direct(f)) {
					close(f);
					dup(savinp);
					close(savinp);
					savinp = 0;
					prs(np);
					prs(": autostart not found\n");
				}
				continue;
			case 'e':
				/* echo command file as executed */
				echflag++;
				continue;
			default:
				prs(np);
				err(": unknown switch");
				break;
			}

			break;	/* if not "continue"d above, break loop */
		}

		/* arg not a switch --> command file */
		promp = 0;
		close(0);
		f = open(np, 0);
		if (f < 0 || direct(f)) {
			close(f);
			prs (np);
			err (": cannot open");
		}

		/* set pointers for $0 -- $9 */
		dolv = --v;
		dolc = c + (av-v);

		/* shell always ignores ^c, ^b */
		/* if command file nohup'd, all progs started will also be */
		/* otherwise all non-background jobs will be interruptable */
		/* a command file shell will die if any of its children */
		/* return with exit status indicating ^c termination */
		/* so in effect, the ^c terminates the shell also. */
		if (signal(INTR, 1) != 0) setintr = 0;
		break;
	}
	v = av;
	if (equal(v[0], "--")) {
		/* "--" is special (at the moment), reserved for login */
		/* byeflg is set, meaning */
		/* accounting must be done on exit  (exec "/etc/byebye") */
		/* alternative method would be to implement a get ppid */
		/* to determine if the shell is a child of init, and hence */
		/* the top level shell */
		byeflg++;
		prepromp = 0;
	}

	/* pretty up the name shown by systat */
    /* avoid problem if no arg[0] */
    if (v[0] != -1) {
	for (np = v[0]; *np; *np++ = 0);
	np = v[0];
	*np++ = promp? ptem: '-';
	*np++ = prepromp;
    }
	savpromp = promp;
	if (savinp) promp = 0;

	/* getluid returns login uid (determined by owner of file */
	/*  handle 2) */
	/* getpath returns the login directory path for given uid */
	/* mypath is used to replace "$=" in command line */
	/* also used to form <login path>/save.txt for $a-$z */
	mypath = getpath(getluid());
	/* close extra file handle */
	if (pich > 0) close(pich);
	gtty(1, ttmode);	/* use 1 here because maybe not dup'd yet */
	svfh = -1;

}

eof()
{
	register char **v, *s;

	/* eof on command file; exit only if not */
	/* autostart-type temporary diversion */
	if (savinp != 0 && noreset == 0) {
		/* running an autostart, or non-subshell command file */
		close(0);
		dup(savinp);
		close(savinp);
		promp = savpromp;
		savinp = 0;
		reset();	/* should return to main loop */
	}
	exit(0);
}

byebye()
{
	signal(1,1); signal(2,1); signal(3,1);
	if (promp) {	/* reset tty mode */
		ttmode[2] =& ~DDTMODE;
		stty(2,ttmode);
	}
	/* do accounting if necessary */
	if (byeflg) execl("/etc/byebye", "byebye", 0);
	exit(0);
}
