#
#include "hsh.h"
#include "hshdb.h"
#include "/h/stat.h"

fileok(str, flgs)
char *str;
int flgs;
{
	register f;
	register char *cp, c;
	char wild, logp;
	int mode;

	f = flgs;
	if ((f & (EXST|NOEXST|NEW_OLD)) == 0) return(1);
	logp = 0; wild = 0;
	for (cp = str; c = *cp++; ) {
		if (c < 0) logp++;	/* parity bit on --> quoted */
		else if (c == '[' || c == '?' || c == '*') {
			if (*cp != '/') {
				wild++;
				break;
			}
			/* "* / logname" harvard glob feature */
			logp++;
		}
	}
	if (wild) {
		if (f & (NOEXST|NEW_OLD)) {
			err2(str,": wild not allowed");
			return(0);
		}
		if (cflags & CONFIRM) {
			confp = mvstrg(" [*wild*]", confp, econfp);
		}
		return(1);
	}
	if (logp) {
		if (f & NEW_OLD) cflags =| CONFIRM;
		return (1);
	}
	mode = statmode(str, uid);
	if (f & EXST) {
		if (mode == -1) {
			err2(str,": non-existent");
			return(0);
		}
		return(1);
	}
	if (f & NEW_OLD) {
		if (mode != -1) {
			if ((mode & IFMT) == 0)	/* simple file */
				confp = mvstrg(" [oldfile]", confp, econfp);
			cflags =| CONFIRM;
		}
		return(1);
	}
	if (mode != -1) {
		err2(str,": already exists");
		return(0);
	}
	return(1);
}

statmode(str, u)
char *str;
int u;
{
	int uu;
	struct inode stbuf;
	register c;
	struct { char lo, hi; };

	if ((c = stat(str, &stbuf)) < 0) return (c);
	uu.lo = stbuf.i_gid;
	uu.hi = stbuf.i_uid;
	c = stbuf.i_mode;
	if (uu == u) return(c);
	return(c&0177000|((c&07)<<6));
}

direct(f)
{
	struct inode stbuf;

	/* return -1 if file handle not legal, 1 if directory, 0 otherwise */
	if (fstat(f, &stbuf) < 0) return (-1);
	return((stbuf.i_mode&IFMT) == IFDIR);
}
