\ 
.ll 72
.br
NAME

	submit -- HARV/UNIX submit-for-background program

SYNOPSIS

	submit [commandfile [switch] [switch] ...]

DESCRIPTION
.br
\?..

	Submit runs the specified command file in the background.  Switches
are available to control when to start, how long to allow it
to run, how often to repeat execution of the same file, etc.
The command file runs on a pseudo terminal exactly as though
the commands had been typed in to the shell at top level.
A log of the commands and output generated is (if not otherwise specified)
saved in a file called "commandfile.log".

SWITCHES
.br
\?..

.in 25
.ta 6,14,26
.ti 0
	-delete		Delete the command file after
running it for the last time.

.ti 0
	-dlog		Delete the log file after
running the command for the last time.
Presumably, this is used along with a "-print".

.ti 0
	-immediate [file]	Prompt the user for the text
of the command file, which is then
put into "file" and used as the command file.  A "-delete"
is also set.
If file is not specified, then the file "sbmit#####.tmp" is used where
##### is the pid backwords.

.ti 0
	-kill	job#	Kill the specified job.  The job# is that
displayed by the list-queue command.

.ti 0
	-limit	hh[:mm]	Allow the command file to run for only this long.
The default if unspecified is one hour.  This is "connect" NOT "cpu" time.

\?..
.ti 0
	-log	logfile	Save the log in "logfile" rather
than "commandfile.log".

.ti 0
	-nodelete	Opposite of -delete.

.ti 0
	-nodlog		Opposite of -dlog.

.ti 0
	-print		Print the log-file on the printer after the
last run of the command file.

.ti 0
	-queue		List the queue of submitted command files.  Those
which are running will be starred and will list
a pseudo terminal name (which may be used for systat).

.ti 0
	-verbose	Same as "-queue" but gives a more
verbose listing.

\?..
.ti 0
	-when	time[,inc][,rpt]	Do not run the command file
until the specified "time", and then (if "inc" is given) run it again
after the specified increment of time.
If "rpt" is given, repeat the command only "rpt" times.
(default is forever if "inc" is given without "rpt".)

.ti 0
	-when	+hh[:mm]	Start the job "hh:mm" in the future.

\?..
.in 0
	If no arguments or switches are given, -queue is assumed.

	When specifying "time," the following form is used:

		[d-mon[-yy]@]hh[:mm]

	Where d is the day, mon is the 3-letter abbreviation
of the month, yy is the year, hh is the hour, mm is the minute.  Brackets
indicate optional fields.  E.g.:

		11-mar-77@3:15
		14-apr@2
		4:20
	etc...
.br
\?..
Note: If the current directory is not the login-directory,
and if the command-file !does not! start with "chdir ", then
it is copied to a temporary file with a "chdir" added
as the first command. The "-delete" flag is
set to remove the temporary after the run, and the log
file takes the original name.  To avoid this extra file copy,
it is suggested that all command files start with
a "chdir <appropriate directory>" as their first line.
.pl 2
