#
/*
 * cr -- cr11 card reader driver
 */

#define CRADDR	0177160

struct{
	int csr;
	int db1;
	int db2;
};

#include "/usr/sys/param.h"
#include "/usr/sys/buf.h"
#include "/usr/sys/conf.h"
#include "/usr/sys/user.h"

#define	EOFCHAR	037	/* CDC 6/7/8/9 multi-punch */

#define ERRORS	0134000
#define GO	0101
#define OFFLINE	0400
#define DONE	040000

#define OPEN	01
#define ERROR	02

#define CRPRI	003

struct{
	int	flags;		/* device state flags */
	char	*bp;		/* pointer to next available position */
	char	card[82];	/* room for 1 card + 1 char */
	int	blen;		/* length of this line */
} cr;

cropen()
{
	if((cr.flags&OPEN) || (CRADDR->csr&OFFLINE))
		u.u_error = EACCES;
	else {
		cr.flags = OPEN;
		cr.blen = 0;
	}
}

crclose()
{
	cr.flags = 0;
}

crstart()
{
	register char *p;
	register int i;

	cr.bp = cr.card;
	cr.flags =& ~ERROR;
	CRADDR->csr =| GO;
	sleep(&cr, CRPRI);
	cr.blen = 81;
	p = &cr.card[80];
	while(*p-- == 0)		/* trim trailing blanks */
		cr.blen--;
}

crread()
{
	register i, k;
	register char *p;

	crstart();
	if(cr.flags & ERROR){
		u.u_error = EIO;
		return;
	}
	if(cr.card[0] == EOFCHAR)
		return;
	k = min(u.u_count, cr.blen);
	p = cr.card;
	for(i=0; i<k; i++)
		passc(*p++);
}

crintr()
{
	*cr.bp++ = CRADDR->db2;
	if(CRADDR->csr & ERRORS)
		cr.flags =| ERROR;
	if(CRADDR->csr&DONE)
		wakeup(&cr);
}
