# define listsize 12000 
extern int list[listsize];
/* The array list is used as follows: 
      list(1) = the source end-of-line flag. 
      list(2) = source parameter flag. 
      list(3) = mct end-of-line flag.
      list(4) = mct parameter flag.
      list(5) = the character zero.
      list[6] = symbol generator (initialized to 100).
      list[7] = space for a parameter 0 value.
      list[8] through list[16] = space for parameter 1-9 values.
      list[17] and up = space for macro definitions and temporaries.
 
   Variables i, j, k, l, m, n are used as pointers and temporaries.
   
   Each macro is stored as a block. If list[m] is the first element,
   then the layout of the block is -

      list[m] = index of next macro template.
      list[m+1] = largest modifier of a parameter 0 call used in 
                this macro. If parameter zero is not used in the 
                macro, list[m+1]=-1. The symbol generator will be
                incremented by (list(m+1)+1) after the code body
                has been completely scanned.
      list[m+2] = First character of the template. ASuccessive 
                elements of list contain successive characters of 
                the template. The end-of-line flag is replaced by 
                -1. The code body lines follow, 1 character per word, 
                each terminated by -1.

   Within a code body, each parameter call is represented by three 
   elements.  The first element contains -2, the second is the index 
   of the element of list in which the parameter value will be stored
   by the template match, and te third contains the integer value
   of the modifier digit. For example, if " is the mct parameter
   flag, then "41 is stored as:

      -2    (marker to indicate the parameter call)
      +11   (parameter 4 value will be stored at list(11))
      +1    (integer equal to character 1)

*/
 main()
 { int i, j, k, l, m, n, kmax; 
   kmax = listsize - 80; 
/*  read the flag line */
   if (readin(list, 1, &i)) stop(10);
/* initialize the symbol generator and the macro definition index. */

   list[6] = 100; 
   k = 18; 

/* read one macro definition. The symbol generator increment 
   for the macro is initially -1.  It will be modified as calls 
   on parameter zero are recognized. */

l1: list[k] = -1; 

/* read the template line for the macro */
   if (readin(list + 1, k, &i)) stop(11); 
   if (i >= kmax) stop(20); 
   list[i+1] = list[1]; 
   i = k;
l2: ++i; 
   if (list[i] == list[1]) goto l13; else goto l2; 
l10: ++i; 
   if (list[i] == list[3]) goto l12; 
l11: if (list[i] != list[4]) goto l10;
   list[i] = -2;
   list[i+1] = list[i+1] - list[5] + 7;
   i =+ 2;
   list[i] =- list[5];
   if (list[i-1] != 7) goto l10;
   if (list[k] < list[i]) list[k] = list[i];
   goto l10;
l12: list[i] = -1; 
l13: ++i;
   if (readin(list, i, &j)) stop(12); 
   if (j >= kmax) stop(21); 
   list[j] = list[3];
   if (list[i] != list[3]) goto l11;
   list[k-1] = i;
   k = i + 1;
   if (k >= j) goto l1;
   if (list[k] != list[3]) goto l1;
l20: if (readin(list, i,  & n)) return(0);
   list[n] = list[1];
   m = 17;
l30: l = 8;
   j = m+1;
   for (k = i; k <= n; ++k) 
      { ++j; 
      if (list[j] == list[2]) goto l32;
      if (list[j] != list[k]) goto l31;
      if (list[j] == list[1]) goto l40; else goto l33;
l31: m = list[m]; 
      if (m<i) goto l30;
      if (writeout(list, i, n)) stop(30); 
      goto l20;
l32:  if (list[k] == list[1]) goto l31;
      list[l] = list[k];
      ++l; 
l33: 
      }; 
l41: list[k] = list[j]; 
l42: ++k;
l43: ++j;
   if (list[m] == j) goto l48;
   if (list[j] < - 1) goto l44; 
   else if (list[j] == - 1) goto l47; 
        else goto l41; 
l44: l = list[j+1]; 
   j =+ 2;
   if (l == 7) goto l45;
   if (list[j] != 0) goto l46;
   list[k] = list[l]; 
   goto l42; 
l45: list[7] = list[j] + list[6]; 
l46: list[k] = list[l] / 100; 
   n = list[l] / 10; 
   list[k + 1] = n - list[k]*10 + list[5]; 
   list[k+2] = list[l] - n*10 + list[5]; 
   list[k] =+ list[5]; 
   k =+ 3; 
   goto l43;
l47: if (writeout(list, i, k)) stop(31); 
l40: k = i; 
   goto l43;
l48: list[6] = list[m+1] + list[6] + 1; 
   goto l20; 
   }

readin(l, i, o) 
   int *l, i, *o; 
   { char c; 
   int *p; p = l + i;
   c = getchar();
   while (c != '\n' 
          & c != '\0' 
            & p < &list + sizeof list ) 
      { *(p++) = c; c = getchar(); };
   if (c != '\n') return(1); 
   *o = p - l;
   return(0);
   }

writeout(l, b, e) 
   int *l, b, e; 
   { int p;
   for (p = b; p < e; ++p) 
      {putchar(l[p]);};
   putchar('\n'); 
   return(0);
   }

stop(s) int s; 
   {printf("stop %d \n", s); 
   exit(s); 
   }

