#

/*
 *	teus hagen
 *	mathematisch centrum
 *	amsterdam
 *	1976
 */

/* 
 * A sendprogram for the gt40. It expects a module in a special
 * format,resp the bytes:
 * 	01,0,01,0,"bytecount" lower byte,higher byte,
 *	"loadaddress" lower byte, higher byte,
 *	the data segment,
 *	"checksum" lower byte,
 *	perhaps more of such modules
 *	01,0,01,0,06,0,"start address" lower byte, higher byte,
 *	"check sum" lower byte.
 * A call with argument " - " gives you a glimp in the MC-Funhouse
 * with the game /usr/games/gt40/file.
 *
 */

#define intrpt	2
#define newmode	040+0300	/*RAW + ANYP*/
#define stop 0177
#define oke  'E'
#define	displaydev	"/dev/tty1"

char	*file	"b.out", *playfile	"/usr/games/gt40/          ",
	*dspl	"display:", 
	*nr[]	{"first","second","third","fourth","fifth",0},
	**loading  nr;
int	gt40,owner,child1,child2,who,mode[3],oldmod;
struct	inode {
		int	dev;
		int	inum;
		int	flags;
		char	nlink;
		char	uid;
		char	gid;
		char	sizo;
		int	size;
		int	ptr[8];
		int	atime[2];
		int	mtime[2];
	};

quit()	{ extern who; exit(who);}

fixtty(){
	struct inode sbuf; extern gt40,owner,mode[3];
	fstat(gt40,&sbuf); owner = sbuf.flags & 0777;
	chmod(displaydev,0600);
	gtty(gt40,mode); oldmod = mode[2]; mode[2] = newmode;
	stty(gt40,mode);
	}

resettty(){
	extern mode[3];
	mode[2] = oldmod; stty(gt40,mode); chmod(displaydev,owner);
	}

int	display( fdesc,func) {
	char buffer[512], *ptr, outbuf[4]; int bytec,i,char1,char2; extern gt40;
	if(fdesc == -1) return(-1);
	if(func) write(gt40,"}R}L@@@@@@@@@@@@",16);
	while(bytec = read(fdesc,buffer,510)){
		if(bytec<0) return(-1); ptr = buffer;
		while(bytec>0){
			char1 = *ptr++; char2 = *ptr++;
			outbuf[0] =  (char1>>2) & 077;
			outbuf[1] = ((char2>>4) & 017) + ((char1<<4) & 060);
			char1 = *ptr++;
			outbuf[2] = ((char1>>6) & 03)  + ((char2<<2) & 074);
			outbuf[3] =   char1     & 077;
			for (i=0;i<4;i++) if (outbuf[i]<040) outbuf[i] =+ 0100;
			write(gt40,outbuf,4); bytec =- 3;
		}
	}
	return(0);
	}

main(argc,argv) char **argv;{
	char *ptr,ear; int fdescr;
	if (argc>1){
	gt40 = open(displaydev,2);
	if (ttyn(2) != '1') exit();
		if (argv[1][0] == '-') {
				write(gt40,"}R                 ",19);
				write(gt40," the   M C - F U N H O U S E \n",30);
				write(gt40,"\n\n\n\n\n\n\n\n\n\n\n\n",12);
			sleep(3); ptr = &playfile[16]; 
			do *ptr++ = *argv[2]; while (*argv[2]++);
			file = playfile;
		} else file = argv[1];
	}
	gt40 = open(displaydev,2); /*extent later*/
	fixtty();

	while ( **loading ){
	if((fdescr = open(file,0))<0){ perror(dspl); resettty();exit();}
/* split proces in three parts:
 * child1, a sendfreak, is doing the work.
 * child2, the lazy one, is listening.
 * parent is watching the children.
 */
	if((child1 = fork()) == -1){ perror(dspl); resettty(); exit();}
	if(child1){
		/* the parent */
		if((child2 = fork()) == -1){ kill(child1,intrpt); wait(&who);
					printf("}R display: forkfailure\n\r");
					resettty(); exit();}
		if(child2){
		/* still the parent proces */
		wait(&who); switch(who>>8){
		case -1: /*read error inputfile */
		case  0: /*load file done */
		         **loading = 0; kill(child2,intrpt);
			 wait(&who); break;
		case  1: /*load error */
			 kill(child1,intrpt); wait(&who);
			 printf("}R %s incorrect load, sorry\n\r",*loading);
			 loading++;break;
		case  2: /*interrupt of GT40 */
			 kill(child1,intrpt); wait(&who);
			 **loading = 0; break;
		case  3: /*load is oke */
			 kill(child1,intrpt); wait(&who);
			 **loading = 0; break;
		default: /*may not happen */
			 kill(child1,intrpt); wait(&child1);
			 kill(child2,intrpt); wait(&child2);
			 **loading = 0; sleep(1);
			 printf("}R Display failure %o",who);
		}
		if(**loading) printf("\r press start or we try it again");
		sleep(3); continue;
	} else {
		/* child2 is listening */
		who = 20; signal(intrpt,(&quit));
		read(0,&ear,1); /* and wait */
		if(ear == oke) exit(3); 
		else if(ear == stop) exit(2); else exit(1);
	}} else {
		/* child1, the sendfreak */
		who = 10; signal(intrpt,(&quit));
		exit(display(fdescr,1));
	}}
	resettty();
}
