#

/* Header file of definitions for directory editor */

#define	FF     014
#define NL	012
#define DEL	0177

/* file types */

#define	C      01
#define	AS     02
#define	OBJ    04
#define	SRC    010
#define	CHRST  020
#define	ARCH   040
#define	DIREC  0100

/* flag in inode which indicates directory */

#define	DIR    040000

/* number of entries displayed per page */

#define PSIZ	13

/* Max number of files which can be turned on
 * for compilation at one time.
 */

#define NFIL	10

/* number of extra compile flags */

#define NFLAGS	10

/* size in chars of flags */

#define FLAGSIZ	10
int	df,d,f;	/* used as file descriptors */
int	flgflg;	/* number of extra compile flags set */
char	ch;

/* Argument list for compilations and assemblies */

char	*argl[NFIL+2+2*FLAGSIZ]; /* +2: 1 for "cc" or "as", 1 for terminating 0 */

/* Additional prefix and postfix compile flags */

char	preflg[NFLAGS][FLAGSIZ+1]; /* +1 to allow for trailing null */
char	pstflg[NFLAGS][FLAGSIZ+1]; /*  "  */

/* Structure of a real directory entry */

struct	dir {
	int inm;
	char name[16];
} dirent;

/* Structure of a dfile entry, with added info */

struct	fdir {
	char flags;
	char type;
	char fname[16];
	char mesg[12];
} dfent;

/* Structure of info returned by "stat" sys call */

struct	finfo {
	char min;
	char maj;
	int  inumb;
	int  flgs;
	char nlinks;
	char uid;
	char gid;
	char size0;
	int  size1;
	int  addr[8];
	long actime;
	long modtime;
} statb,fdstatb;

/* Structure of intermediate holding array,
 * used in creating compilation argument list.
 */

struct {
	char fl;
	char dummy;
	char *nm;
} files[NFIL];

struct	fdir *fdirp;
struct	fdir *rfdirp;

int nent,maxp;

