#

#define DIROFFSET	6	/*number of sectors before directory*/
#define FIRSTDIRSEG	1	/*log. num. of first dir. seg.*/
#define NULLDIRSEG	0	/*nextseg entry of last dir. seg.*/
#define DIRSEGSC	2	/*directory segment sector count*/
#define DIRSEGHEDWC	5	/*directory segment header word count*/
#define DIRSEGHEDBC	10	/*directory segment header byte count*/
#define DIRSEGENTWC	512-5	/*directory segment entry word count*/
#define DIRSEGENTBC	1024-10 /*directory segment entry byte count*/

#define ENTRYWC 	7	/*directory entry word count*/
#define ENTRYBC 	14	/*directory entry byte count*/

struct dirseg	{		/*directory segment*/
	int	d_numsegs;	/*num. of directory segments*/
	int	d_nextseg;	/*num. of next directory segment*/
	int	d_highseg;	/*num. of highest segment currently open*/
	int	d_xtraby;	/*num. of extra bytes/directory entry*/
	int	d_start;	/*block num. where segment's files begin*/
	int	d_entries[DIRSEGENTWC];
	};

struct entry	{
	int	e_status;	/*status word*/
	int	e_name[2];	/*name*/
	int	e_ext;		/*extension*/
	int	e_length;	/*total file length*/
	int	e_unused;	/*"data length"*/
	int	e_date; 	/*date*/
	int	e_extra[0];	/*extra words*/
	};

#define S_TENTATIVE	00400
#define S_EMPTY 	01000
#define S_PERMANENT	02000
#define S_ENDSEG	04000

#define READ	0
#define WRITE	1

/*error numbers for perror calls*/
#define EINVAL	22
#define ENOENT	2
#define EPIPE	32
#define ENOSPC	28
