#
/*
 *      File master.c: connect/reconnect to opser program
 *                              written by Bob Greenberg
 */


struct { int inode; char name[14]; } dir[16];
char *fnm;

main()
{
	extern int quit();
	register int n, p, c;
	int k;

	p = open(".",0);
	while ((k = read(p,dir,16*16)/16) > 0)
		for (c=0; c<k; c++)
			if (dir[c].inode != 0 && (n=match(dir[c].name)))
				goto gotit;
	if (k < 0)
	{
		printf("??Can't read directory.\n");
		exit(1);
	}
	signal(2,1);
	if ((n=fork()) == -1) {printf("Can't create OPSER?\n"); exit();}
	if (n==0)
	{
		execl("/etc/opser","*opser*",0);
		exit(1);
	}
	printf("[Creating OPSER]\n");
	signal(3,&quit);
	if ((n = creat(fname(n),0644)) < 0)
	{
		printf("?Can't write OPSER file.\n");
		exit(1);
	}
	close(n);
	wait();
	printf("[OPSER exited]\n");
	unlink(fnm);
	exit(0);
gotit:  signal(2,1);
	if ((c = alive(n)) == 0)
	{
died:           printf("?Old OPSER died.\n");
		unlink(fnm);
		exit(1);
	}
	else if (c < 0)
	     {
		printf("?Can't read proc table.\n");
		exit(1);
	     }
	printf("[Re-entering OPSER]\n");
	kill(n,1);
	signal(3,&quit);
	for (;;) sleep(3600);
}

match(s)
{
	register char *p, *p2;
	register int n;

	p = fnm = s;
	p2 = "opser.";
	while (*p2) if (*p++ != *p2++) return(0);
	if ((n = open(s,1)) < 0) return(0);
	close(n);
	return(atoi(p));
}

fname(q)
{
	register int n, x;
	register char *p;
	char *p2;
	x = q;
	p2 = "opser.      ";
	p = p2+11;
	for (n=0; n<6; ++n) {*p-- = (x%10) + '0'; x =/ 10;}
	return(fnm=p2);
}

quit()
{
	printf("\n[%s]\n",(open(fnm,0) < 0)? "OPSER exited" :"Leaving OPSER");
	exit(0);
}

#include "/usr/sys/param.h"
#include "/usr/sys/proc.h"
alive(pidd)
{
	struct proc procs[2*NPROC];
	register struct proc *p;
	register int pid, n;

	pid = pidd;
	if (gprocs(0) >= 2*NPROC) return(-1);
	n = gprocs(procs);
	for (p = &procs[0]; p < &procs[n]; p++)
		if (p->p_stat && p->p_pid == pid)
			if (p->p_uid == (getuid() & 0377)) return(1);
			else
			{
				printf("?Not the same user.\n");
				exit(1);
			}
	return(0);
}

/* NON-RBGUNIX version:
alive(pid)
{
	register int i, *n, mem;
	struct proc procs[NPROC];
	struct { char sname[8]; int  type; char  *value; } nl[2];

	if ((mem = open("/dev/mem",0)) < 0) return(-1);
	n = nl;
	*n++ = '_p'; *n++ = 'ro'; *n++ = 'c';
	for (i = 10; --i;) *n++ = 0;
	nlist("/unix",nl);
	if (nl[0].type == 0) return(-1);
	seek(mem, nl[0].value, 0);
	if (read(mem, procs, sizeof procs) < sizeof procs) return(-1);
	close(mem);
	for (i = 0; i < NPROC; i++)
	.
	.
	.
*/
