.ul
.ce 7
THE POP WINDOWING SYSTEM - setup instructions
.sp 3
Jon Rowson
.sp 1
Computer Systems Laboratory
.br
Queen Mary College
.br
University of London
.br
Mile End Road
.br
London E1 4NS
.sp 2
The POP windowing system is suitable
only for vdus with a remote cursor positioning capability
and run at speeds of 1200 baud or more (preferably at least 9600 baud).
Even though they are specially designed
to reduce the amount of
display work performed by
the terminal, a low
speed line will make the system too slow.
If your terminal has any extras then you can probably do better.
.s3
.ti-5
.ul
Screen Size
.br
As distributed, the system is set up for a screen of 18 lines by 80
characters per line.
To change this modify NCHARS and NLINES in "pop/pop.h".
As this is the header file, it would be wise to recompile
everything afterwards (see "pop/run").
.s3
.ul
.ti-5
Positioning the cursor
.br
On our modified ITT 3210s, the cursor is positioned at character position
.it "h,"
line position
.it v
by sending the following sequence:
.br
.ti+15
1) send CONTROL+K
.br
.ti+15
2) send 
.it "v +"
32
.br
.ti+15
3) send
.it "h +"
32
.s3
The cursor positioning function is "s_cursor(h,v)"
in file "pop/screen.c".
.s3
.ti-5
.ul
Clearing the screen
.br
Sending `CONTROL+L' to the ITT 3210
clears the screen. (There is also
a local CLEAR function key.)
See function "s_clear()" in "pop/screen.c".
.s3
.ti-5
.ul
Representation of undisplayable characters
.br
On the ITT 3210, the following characters cannot be displayed:
.br
{     }     ~     |     `
.br
(ie 0140, and 0173 thru 1076)
.br
They are instead be represented
by:
.br
\\(     \\)     \\^     \\!     \\'
.s3
The conversion is only made if ITT mode is set in the POP.
If you need to change these, then
see:
.br
char ctab[] in "pop/main.c".
.br
the relevant chars. are of POP character class MAP.
Also see
.br
char *itts;
.br
char *maps;
.br
in "pop/pgetl.c" for the character
mappings when reading a line.
.s3
.ti-5
.ul
TTY mode
.br
As set up, the system operates in RARE mode which is precisely
the same as RAW mode except that interrupts and quits are
signalled by the tty driver.
This is not necessary and the system will operate
fine in RAW mode.
However, unless you are prepared to implement
RARE mode, you will have to make a modification
to the initialization function "do_init()" in "pop/main.c".
Changing the T_RARE definition to 040 (for RAW mode)
should do it.
