#

/*
 * checklabel - reads block 0, and checks whether it is a Unix label.
 * It takes the string name, and prepends "/dev/" putting the
 * result in the external string "device".
 * Returns	 0  Recognized label
 *		 1  Unix bootstrap lock
 *		-1  Unknown
 */

#include	"label.h"

extern char	device[], bootprog[], label_header[], label[];


check_label( name )
char	*name;
	{
	int	c, length, filedes;
	char	boot[512];
	char	*labelp, *headerp, *devp, *bootp, *p, *namep;

	/* Make up device name */
	p = "/dev/";
	devp = device;
	while ( *p != '\0' )
		*devp++ = *p++;
	namep = name;
	for ( c= 0;  c <NAMELENGTH;  c++ )  {
		if ( *namep == '\0' )
			break;
		*devp++ = *namep++;
		}
	if ( *namep != '\0' )  {
		printf("Name to long:  %s\n", name );
		exit(-1);
		}
	*devp = '\0';

	/* Check device is ok */
	if ( (filedes= open( device,0)) < 0 )  {
		printf("Can't read device:  %s\n", device );
		exit(-1);
		}
	if ( read( filedes,label,512 ) != 512 )  {
		printf("Read error on:  %s\n", device );
		exit(-1);
		}
	close( filedes );

	/* Is it a GUCS Unix label ? */
	labelp = label->header;
	headerp = label_header;
	while ( *headerp == *labelp  &&  *headerp != '\0' )  {
		headerp++;
		labelp++;
		}
	if ( *labelp == '\0'  &&  *headerp == '\0' )
		return( VALIDLABEL);

	/* Is it a Unix bootstrap program ? */
	if ( (filedes= open( bootprog,0)) < 0 )  {
		printf("Can't read bootstrap program:  %s\n", bootprog );
		exit(-1);
		}
	length = read( filedes, boot, 512);
	close( filedes );
	labelp = label->header;
	bootp = boot;
	for ( c= 0;  c< length;  c++ )
		if ( *labelp++ != *bootp++ )
			/* its not a bootstrap program */
			return( UNRECOGNIZED);

	/* It is a boot program */
	return( BOOTPROGRAM);
	}
