#include	"mac.h"
#include	"mac.x"


/*
 *   Pseudo opcode line listing.
 */
plist(lc)
register int lc;
{
	register struct st *q;
	register int i;
	register int p;
	register int ps;
	int resetlin;

	ps = intercode.i_op;
	p = 0;

	/*
	 *	Dont list listing directives
	 */

	if(ps == 16 || ps == 17) {
		return;
	}

	resetlin = (ps == 18);   /* reset nline if the op is 'include' */

	if(!(OPTION('l') && liston)) {
		/* listing not required */
		if (resetlin) {
			nline = 0;
		}
		return;
	}

	/*
	 *   Call header() if at top of page, and instruction
	 *   to be listed is not 'title' or 'eject'.
	 */
	newpage();

	switch (ps)  {

		case 0:		/* dc's */
		case 1:
		case 2:
		case 3:
		case 13:
			printlc(lc);
			if (OPTION('i')) p += iprint();
			if (OPTION('w')) p += wprint();
			if (OPTION('f')) p += fprint();
			break;

		case 6:		/* align */
		case 7:		/* org */
		case 9:		/* ds */
		case 10:	/* end */
			printlc(lc);
			for (i=0; i < pt.c_dw; i++) putchar(' ');
			break;

		case 4:		/* equ */
		case 14:	/* struc */
		case 15:	/* ends  */
			q = intercode.i_label;
			if (q != NULL)  {
				printl(pt.l_dw, q->s_value);
				}
			for (i=0; i < pt.c_dw; i++)
				putchar(' ');
			break;

		case 5:		/* global */
		case 18:	/* include */
		case 19:	/* lsb */
			for (i=0; i < pt.l_dw + pt.c_dw; i++)
				putchar(' ');
			break;

		case 8:		/* seg */
			printf("  %3d", lcntr);
			for (i=0; i < pt.l_dw + pt.c_dw - 4; i++)
				putchar(' ');
			break;

		case 11:	/* title */
		case 12:	/* eject */
/*
			getlin();
*/
			header();
			return;

		}

	source();			/* print line of source */

	/* print wrap-around code */

	while (p) {
		p = 0;
		lc += pt.l_ai;
		printlc(lc);

		if (OPTION('i')) p += iprint();
		if (OPTION('w')) p += wprint();
		if (OPTION('f')) p += fprint();
		putchar('\n');
		}

	if(resetlin) /* reset line counter after an 'include' */
		nline = 0;

	return;
}

/*
 *   Dud line listing - just print source.
 */
tlist(lc)
{
	register int i;
	register int l;

	if(!(OPTION('l') && liston))
		/* listing not required */
		return;

	newpage();

	if ((l = (int)intercode.i_label) != ERR)
		printlc(lc);
	else
		for (i=0; i < pt.l_dw; i++) putchar(' ');

	for (i=0; i < pt.c_dw; i++)
		putchar(' ');

	source();

	return;
}

/*
 *   Opcode listing.
 */
olist(lc)
{
	register int i;
	register int p;

	p = 0;

	if(!(OPTION('l') && liston))
		/* listing not required */
		return;

	newpage();

	/*  location counter  */

	printlc(lc);

	/* 'word' and/or formatted code */

	if (OPTION('i')) p += iprint();
	if (OPTION('w')) p += wprint();
	if (OPTION('f')) p += fprint();

	/* remainder of line */
	source();

	/* print wrap-around code */

	while (p) {
		p = 0;
		lc += pt.l_ai;
		printlc(lc);

		if (OPTION('i')) p += iprint();
		if (OPTION('w')) p += wprint();
		if (OPTION('f')) p += fprint();
		putchar('\n');
		}

	return;
}
/*
 *	initialize print constants
 */
setprint()
{
	register struct fd *fmt;
	register int i;
	register int j;
	register int d;
	register int max;

	if (OPTION('w')) {
		wf = TRUE;
		} else {
		wf = FALSE;
		}

	if (OPTION('f')) {
		ff = TRUE;
		} else {
		ff = FALSE;
		}

	/* no. of bits per digit */

	pt.c_bw = 4;
	if (OPTION('o')) pt.c_bw = 3;
	if (OPTION('b')) pt.c_bw = 1;

	/* location counter print field */

	if (head.h_i_len > head.h_w_len)
		pt.l_ai = head.h_i_len;
	else
		pt.l_ai = head.h_w_len;

	pt.l_dw = (head.h_addr + pt.c_bw -1)/pt.c_bw;
	if (pt.l_ai == 1) {
		pt.l_iw = 1;

		} else {
		j = pt.l_ai - 1;
		for (i=1; j >>= pt.c_bw; i++);
		pt.l_iw = i;
		}

	/* 'word' format print field */

	pt.w_bw = pt.l_ai * head.h_bu_len;

	pt.w_dw = (pt.w_bw + pt.c_bw -1)/pt.c_bw;
	pt.w_rw = pt.w_bw - (pt.w_bw/pt.c_bw)*pt.c_bw;

	/* formatted code print field */

	pt.f_bw = pt.w_bw;
	/* find longest formatted field */
	max = 0;
	fmt = &memory[0];
	for (i=0; i < head.h_formats; i++) {
		d = -1;
		pt.f_bt = 0;

		if (fmt->f_len < pt.f_bw/bl)
			d += (pt.f_bw + fmt->f_len*bl + pt.c_bw - 1)/pt.c_bw + 1;
		for (j=0; fmt->f_desc[j]; j++) {
			d += (fmt->f_width[j] + pt.c_bw-1)/pt.c_bw + 1;
			pt.f_bt += fmt->f_width[j];
			if (pt.f_bt >= pt.f_bw) {
				if (d > max) max = d;
				d = -1;
				pt.f_bt = 0;
				}
			}
		if (d > max) max = d;
		fmt ++;
		}
	pt.f_dw = max;
	pt.f_bt = 0;

	if (OPTION('i')) pt.i_dw = 20;

	/* width of word & formatted print */

	pt.c_dw = 0;
	if (OPTION('w')) pt.c_dw += pt.w_dw+4;
	if (OPTION('f')) pt.c_dw += pt.f_dw+4;
	if (OPTION('i')) pt.c_dw += pt.i_dw+2;

	return;
}
/*
 *	print location counter field
 */
printlc(lc)
register int lc;
{
	static int lastad;
	register int i;
	register int addr;

	addr = lc/bu;
	if (addr == lastad) {
		for(i=0; i < pt.l_dw; i++) putchar(' ');
		return;
		}
	lastad = addr;

	if ((pt.l_ai != 1) && (lc % pt.l_ai)) {
		for (i=0; i < pt.l_dw - pt.l_iw; i++)
			putchar(' ');
		printl(pt.l_iw,addr);
		return;
		}
	printl(pt.l_dw,addr);
	return;
}
/*
 *	print 'word's of code
 */
wprint()
{
	register int i;
	register int j;
	register int *cp;
	register int b;
	register char *r;

	if (pt.w_bt < pt.w_bw)  {
		for (i=0; i < pt.w_dw+4; i++) putchar(' ');
		return(0);
		}

	cp = locn[lcntr].l_next;
	i = pt.w_bt/bl;
	j = pt.w_bw/bl;
	if (i > j) cp -= (i-j);

	r = fbuf;
	j = bl;
	b = *(--cp);

	for (i=0; i < pt.w_dw; i++) {
		if (!j) {
			b = *(--cp);
			j = bl;
			}

		if (j < pt.c_bw) {
			bp = b & BITMASK(j);
			b = *(--cp);
			bp |= ((b & BITMASK(pt.c_bw-j)) << j);
			b >>= pt.c_bw-j;
			j += (bl - pt.c_bw);

		} else {
			bp = b & BITMASK(pt.c_bw);
			j -= pt.c_bw;
			b >>= pt.c_bw;
			}

		convert(r++);
		}

	/* correct Most-Significant-Digit if necessary */

	if (pt.w_rw) {
		r--;
		bp &= BITMASK(pt.w_rw);
		convert(r++);
		}

	printf("    ");
	for (i=0; i < pt.w_dw; i++) putchar(*(--r));

	pt.w_bt -= pt.w_bw;
	if (pt.w_bt < pt.w_bw) return(0);
	return(1);
}
/*
 *	generate formated code print string
 */
storef(value,width)
char value;
register int width;
{
	register char v;
	register int d;
	register int s;
	char *savefp;

	if(!liston)
		return;

	v = value;
	if (pt.f_bt) {
		if (pt.f_bt == (pt.f_bt / pt.f_bw) * pt.f_bw) {

			*fp++ = '.';

			} else {

			*fp++ = ' ';
			}
		}

	pt.f_bt += width;

	d = width/pt.c_bw;
	s = width - d * pt.c_bw;

	fp += d;
	if (s) fp++;
	savefp = fp;

	while (d-- > 0) {
		bp = v & BITMASK(pt.c_bw);
		convert(--fp);
		v >>= pt.c_bw;
		}

	if (s) {
		bp = v & BITMASK(s);
		convert(--fp);
		}

	fp = savefp;
	return;
}
/*
 *	print formatted code string
 */
fprint()
{
	register int dend;
	register int dbgn;
	register char *i;
	register int j;

	/* find last column */
	dend = pt.f_dw;
	if ((pt.f_bt < pt.f_bw) && pt.w_bt)
		dend -= (pt.f_bw - pt.w_bt + pt.c_bw - 1)/pt.c_bw + 1;

	/* decrement bits-to-print counter */
	pt.f_bt -= pt.f_bw;

	/* find first column */
	if (pt.f_bt <= 0) {
		pt.f_bt = 0;
		dbgn = dend - (fp-1 - fst);

	} else {
		for (i=fst; i <= fp; i++) if (*i == '.') break;
		dbgn = dend - (i-1 - fst);
		}

	/* now go to it */
	for (j=0; j < dbgn+3; j++) putchar(' ');
	for (j=dbgn; j <= dend; j++) putchar(*fst++);
	for (j=dend; j < pt.f_dw; j++) putchar(' ');

	/* is there more to print */
	if (pt.f_bt) {
		fst++;
		return(1);

		} else {
		fp = fst = fbuf;
		return(0);
		}
}
/*
 *	convert a bit pattern to a character
 */
convert(cp)
register char *cp;
{
	if (OPTION('h')) {
		*cp = hextab[bp];

		} else {
		*cp = bp + '0';
		}
	return;
}
/*
 *   Auto-generated pading listing.
 */
pdlist(lc)
{
	register int i;
	register int p;

	p = 0;

	if(!(OPTION('l') && liston))
		/* listing not required */
		return;

	newpage();

	/*  location counter  */

	printlc(lc);

	/* 'word' and/or formatted code */

	if (OPTION('i')) p += iprint();
	if (OPTION('w')) p += wprint();
	if (OPTION('f')) p += fprint();
	putchar('\n');

	/* print wrap-around code */

	while (p) {
		p = 0;
		lc += pt.l_ai;
		printlc(lc);

		if (OPTION('i')) p += iprint();
		if (OPTION('w')) p += wprint();
		if (OPTION('f')) p += fprint();
		putchar('\n');
		}

	return;
}

iprint()
{
	register int i;
	register int l;
	register int len;
	register int *cp;
	int done;

	/*  instruction  */
	cp = locn[lcntr].l_next - length;
	len = prwidth(head.h_bu_len);

	printf("  ");

	for (i=0; i<length && i*len < pt.i_dw; i++)
		printl(len, *cp++);
	done = i;

	/*  padding  */
	l = pt.i_dw - (length * len);
	for (i=0; i<l; i++)
		putchar(' ');

	length -= done;
	return(length > 0);
}

ipad() {
	register int i;

	for(i = pt.i_dw + 2; i > 0; i--)
		putchar(' ');
}


/*
 *   determine # of characters needed to print data.
 */
prwidth(w)
register int w;
{
	register int l;

	if (OPTION('h'))  {
		l = w / 4;
		if (w % 4)
			l++;
		}
	if (OPTION('o'))  {
		l = w / 3;
		if (w % 3)
			l++;
		}
	if (OPTION('b'))
		l = w;

	return(l);
}
