/*
 * Structure for stty and gtty system calls.
 */
#define	MELB_TTY	1
/*
 * If you don't want the Melbourne tty driver, you shouldn't be using
 * this file ...
 *
 * CAUTION: this is not the file we use at Melbourne, I forgot to put
 * it on the tape ... this file was created at U Delaware, and might
 * contain a few bugs ......			kre
 */

struct sgttyb {
        char    sg_ispeed;              /* input speed */
        char    sg_ospeed;              /* output speed */
        char    sg_erase;               /* erase character */
        char    sg_kill;                /* kill character */
        int     sg_flags;               /* mode flags */
};

/*
 * List of special characters
 */
struct tchars {
        char    t_intrc;        /* interrupt */
        char    t_quitc;        /* quit */
        char    t_startc;       /* start output */
        char    t_stopc;        /* stop output */
        char    t_eofc;         /* end-of-file */
        char    t_brkc;         /* input delimiter (like nl) */
};
#define	sg_intr		t_intrc
#define	sg_quit		t_quitc
#define	sg_start	t_startc
#define	sg_stop		t_stopc
#define	sg_eof		t_eofc
#define	sg_brkc		t_brkc

struct	sgttychr {
	char	sg_redisp;
	char	sg_escp;
	char	sg_disc;
	char	sg_dqueue;
	char	sg_delq;
	char	sg_brkin;
};

struct	sgttydel {
	char	sg_nldel;
	char	sg_crdel;
	char	sg_tabdel;
	char	sg_ffdel;
	char	sg_dchar;
	char	sg_ddel;
};

struct	sgttyst {
	short	sg_state;
	short	sg_ttype;
	char	sg_width;
	char	sg_depth;
};

struct	sgttyctl {
	long	sg_dctl;
	char	sg_desc;
	char	sg_delet;
};

struct	sgttypag {
	short	sg_pgflg;
	char	sg_pgdel;
	char	sg_pglen;
	char	sg_pgon;
	char	sg_pgoff;
};

/*
 * Modes
 */
#define TANDEM  01
#define CBREAK  02
#define LCASE   04
#define ECHO    010
#define CRMOD   020
#define RAW     040
#define ODDP    0100
#define EVENP   0200
#define ANYP    0300
#define	UCASE	0400		/* convert lower case -> upper case */
#define	KNL	01000		/* echo '\n' after a kill */
#define	RO_TYPE	06000		/* RO mode selected: (dflt is echo RO char) */
#define	RO_VDU	02000		/* 	echo ' ', '\b', ' ' */
#define	RO_HARD	04000		/*	echo char deleted (in '#' marks) */
#define	WRAP	010000		/* send '\n' if next char won't fit on line */
#define	PAGE	020000		/* pause output after page is full */
#define	HOLDSTOP 040000		/* don't go after ^S till have ^Q */
#define	DCASE	0100000		/* display the case actually read */

#define	ctl(x)	((x)&037)	/* control equiv of a printing char */

/*
 * Special 'delay' algorithms
 */
#define	XTABS	0200		/* convert tabs to spaces */
#define	XFORM	0200		/* simulate form feed using newline */
#define	TAB_37	0201		/* tab delay calc for tty 37 */
#define	NL_37	0201		/* nl delay calc for tty 37 */

/* Page mode flags */
#define	PG_STOP		01	/* stop output at each page end */
#define	PG_PAUSE	02	/* pause for fixed time at page end */
#define	PG_FIXD		04	/* page size fixed - regardless of input */
#define	PG_CLEAR	010	/* clear page just before starting new one */
#define	PG_NLGO		020	/* only ^Q, \n and EOT resume from page hlt */

/*
 * Speeds
 */
#define B0      0
#define B50     1
#define B75     2
#define B110    3
#define B134    4
#define B150    5
#define B200    6
#define B300    7
#define B600    8
#define B1200   9
#define B1800   10
#define B2400   11
#define B4800   12
#define B9600   13
#define EXTA    14
#define EXTB    15

/*
 * tty ioctl commands
 */
#define	TIOCGETD	(('t'<<8)|0)
#define	TIOCSETD	(('t'<<8)|1)
#define	TIOCHPCL	(('t'<<8)|2)
#define	TIOCMODG	(('t'<<8)|3)
#define	TIOCMODS	(('t'<<8)|4)
#define	TIOCGETP	(('t'<<8)|8)
#define	TIOCSETP	(('t'<<8)|9)
#define	TIOCSETN	(('t'<<8)|10)
#define	TIOCEXCL	(('t'<<8)|13)
#define	TIOCNXCL	(('t'<<8)|14)
#define	TIOCFLUSH	(('t'<<8)|16)
#define	TIOCSETC	(('t'<<8)|17)
#define	TIOCGETC	(('t'<<8)|18)
#define	TIOCSBRK	(('t'<<8)|19)
#define	TIOCGDEL	(('t'<<8)|20)		/* get delay values */
#define	TIOCSDEL	(('t'<<8)|21)		/* set delay values */
#define	TIOCGETS	(('t'<<8)|22)		/* get tty type etc */
#define	TIOCSETS	(('t'<<8)|23)		/* set tty type etc */
#define	TIOCXBRK	(('t'<<8)|24)		/* xmit 250 ms space */
#define	TIOCRSTO	(('t'<<8)|25)		/* don't discard output */
#define	TIOCGCTL	(('t'<<8)|26)		/* get ctl char echo info */
#define	TIOCSCTL	(('t'<<8)|27)		/* set ctl char echo info */
#define	TIOCSCHR	(('t'<<8)|28)		/* set some more chars */
#define	TIOCGCHR	(('t'<<8)|29)		/* get cur state of above */
#define	TIOCMPTY	(('t'<<8)|30)		/* find out if input q empty */
#define	TIOCDELAY	(('t'<<8)|31)		/* delay output for arg ms */
#define	TIOCGPAG	(('t'<<8)|32)		/* get page mode ctl info */
#define	TIOCSPAG	(('t'<<8)|33)		/* set page mode ctl info */
#define DIOCLSTN        (('d'<<8)|1)
#define DIOCNTRL        (('d'<<8)|2)
#define DIOCMPX         (('d'<<8)|3)
#define DIOCNMPX        (('d'<<8)|4)
#define DIOCSCALL       (('d'<<8)|5)
#define DIOCRCALL       (('d'<<8)|6)
#define DIOCPGRP        (('d'<<8)|7)
#define DIOCGETP        (('d'<<8)|8)
#define DIOCSETP        (('d'<<8)|9)
#define DIOCLOSE        (('d'<<8)|10)
#define DIOCTIME        (('d'<<8)|11)
#define DIOCRESET       (('d'<<8)|12)
#define FIOCLEX         (('f'<<8)|1)
#define FIONCLEX        (('f'<<8)|2)
#define MXLSTN          (('x'<<8)|1)
#define MXNBLK          (('x'<<8)|2)

/*
 * Terminal type codes
 *
 *	CAUTION:
 *		the numbers here are meaningless,
 *		eventually a rational numbering scheme will be chosen
 */
#define	UNKNOWN		0
#define	VC404		1
#define	TRY1061		2
#define	VT52		3
#define	INT8001		4
#define	LA36		6
#define	LS120		7
#define	LA180		8
#define	CAR300		9
#define	DIAB1620	10
#define	TTY43		11
#define	ASR33		12
#define	TTY37		13
#define	ADM3A		14
#define	TEK4010		15
#define	TEK4012		16
#define	TEK4014		17
#define	TEK4015		18
#define	CDC713		19
#define	VT100		20
#define	TI700		21
#define	VT05		22
#define	VIS200		23
#define	HZL1500		24
#define	ADS520		25
