/*
 *  RL disk driver
 *  wfj 8/20/79
 *
 *  Note: if you use this on the 11/70, make sure you've
 *  setup the unibus map. elsewise you will suprise yourself
 *  somewhere in low core (not exactly sparks, but...)
 *  the new bootstrap does this, so don't worry.
 */

#include <sys/param.h>
#include <sys/inode.h>
#include "saio.h"


#define WCOM 012
#define RCOM 014
#define CRDY 0200
#define ERRORS 0176000
#define SEEKHI 5
#define SEEKLO 1
#define RDHDR 010
#define SEEK 06

struct device
{
	int rlcs, rlba, rlda, rlmp;
};

#define RLADDR  ((struct device *)0174400)
rlstrategy(io,func)
register struct iob *io;
{
	register com;
	daddr_t bn;
	int dn, cn, sn,head,diff,cur;

	RLADDR->rlda=013;
	RLADDR->rlcs=4;
	while((RLADDR->rlcs&CRDY)==0);

	dn = io->i_unit;
	bn= io->i_bn;
	cn = bn/20;
	sn = (bn%20) << 1;
	com = (segflag<<4) | (dn<<8);

	RLADDR->rlcs=RDHDR;
	while((RLADDR->rlcs&CRDY) == 0);
	cur = (RLADDR->rlmp&077700) >>6;
	diff= (cn>>1) - (cur>>1);
	head= (cn&1) << 4;
	if(diff <0) RLADDR->rlda= (-diff<<7) | SEEKLO | head;
	else RLADDR->rlda= (diff <<7 ) | SEEKHI | head;
	RLADDR->rlcs = (dn<<8) +SEEK;
	while((RLADDR->rlcs&CRDY) == 0);
	RLADDR->rlda = (cn<<6) | sn;
	RLADDR->rlba = io->i_ma;
	RLADDR->rlmp = -(io->i_cc>>1);
	if( func == READ) com |=RCOM; else com |= WCOM;
	RLADDR->rlcs = com;
	while((RLADDR->rlcs&CRDY) == 0);
	if(RLADDR->rlcs & ERRORS)
	{
		printf("disc error: csr=%o ",RLADDR->rlcs);
		RLADDR->rlda=013; RLADDR->rlcs=4;
		while((RLADDR->rlcs&CRDY) == 0);
		printf(" err=%o\n",RLADDR->rlmp);
		return(-1);
	}
	return(io->i_cc);
}
