#
/*// format of a symbol entry in the main table */

struct symtab {
	char name[8];		/*//symbol name */
	int  flags;			/*//bit flags */
	int  tlnk;			/*//table link */
	int  vl1;			/*//symbol value */
	int  vl2;			/*//used by directives */
};

/*// flags for symbols */
#define SYDF	0100000		/*//defined */
#define SYEQ	0040000		/*//equated */
#define SYEP	0020000		/*//entry point */
#define SYER	0010000		/*//equated register */
#define SYXR	0004000		/*//external reference */
#define SYRL	0002000		/*//relocatable */
#define SYOP	0001000		/*//symbol is really an operator */

/*//flags for opcodes and directives */
#define OPDR	0100000		/*//0=>opcode, 1=>directive */
#define OPFF	017			/*//type of instruction */
#define OPF0	0
#define OPF1	1
#define OPF2	2
#define OPF3	3
#define OPF4	4
#define OPF5	5
#define OPF6	6
#define OPF7	7
#define OPF8	8

struct irts {
	char *irle;		/*//ptr to last entry in chain */
	char *irfe;		/*//ptr to first entry in chain */
};


/*//intermediate text file */
/*//format of the intermediate text for one statement: */

/*//	****************************************************** */
/*//	*  it type             *     # it entries            * */
/*//	****************************************************** */
/*//	*       absolute line number                         * */
/*//	****************************************************** */
/*//	*  it type = 1         *                             * */
/*//	****************************************************** */
/*//	*  symbol table pointer for stmt label               * */
/*//	****************************************************** */
/*//	*  it type             *  relocation flag            * */
/*//	****************************************************** */
/*//	*            value                                   * */
/*//	****************************************************** */
/*//                         . */
/*//                         . */
/*//                         . */
/*//	****************************************************** */
/*//	*  it type             *  relocation flag            * */
/*//	****************************************************** */
/*//	*               value                                * */
/*//	****************************************************** */

/*//	it type				meaning */
/*//		0			beginnning of statement */
/*//		1			value is pointer to symbol table */
/*//		2			value is a constant */
/*//		3			value is a specal char */

struct it {
	char itty;		/*//it type */
	char itrl;		/*//relocation flag or # it entries */
	int  itop;
};

struct {
	int wd1;
	int wd2;
};

struct {
	char char1;
	char char2;
};

struct {
	char lobyte;
	char hibyte;
};

/*// parameters thatdefine the main table */
#define SZMT 1000			/*//initial size of the main table */
struct symtab  maintab[SZMT];	/*//main table */
int cszmt;				/*//current size of main table */
char *bmte;				/*//beginning of main table */
char *emte;				/*//end of main table */

/*// intermediate text types */
#define ITBS	0		/*//beginning of statement */
#define ITSY	1		/*//pointer to symbol table */
#define ITCN	2		/*//constant */
#define ITSP	3		/*//special */
#define ITIGN	-1		/*//ignore this it item */

#define ITBSZ	256		/*//size of the it buffer */
int itbuf[ITBSZ];		/*//it buffer */

#define IOBSZ	512	/*//size of the buffer for the binary output */
char iobuf[IOBSZ];

struct it stbuf[64];		/*//holds it for one statement */

char sbuf[512];		/*//holds one block of sorce */

/*//initial reference table for symbols */
#define SZIRT	64
int sirt[SZIRT];

/*//initial reference table to opcodes */
int oirt[SZIRT];


int absln;		/*//absolute line number */
int ecnt;		/*//error count */
int fbufad;		/*//first it buffer address -1 if no buffer */
int fcflg;		/*//0=>passed an item.  1=>first char */
int fchr;		/*//first char in term */
int	gnspf;		/*//gen specifier */
int ifn;		/*//source file descriptor */
int itix;		/*//index thru it buffer */
int itwc;		/*//number of wordsin it buffer */
int itype;		/*//type of item */
int ival;		/*//value of item */
char *lblpt;		/*//label pointer */
char lbt[8];	/*//holds label name */
char *lmte;		/*//last entry in main table */
int loctr;		/*//location counter */
int nclmt;		/*//number of calls on main table look up */
int nite;		/*//number of entries in stbuf */
int bfn;		/*//binary output file descriptor */
char *opcpt;		/*//pointer to opcode entry in main table */
int p2flg;		/*//0=>pass 1  1=>pass 2 */
int pirt;		/*//entry in initial reference table */
int reloc;		/*//0=>abslute operand   1=>relocatable */
int rlflg;		/*//0=>absolute assembly   1=>relocatable */
int scnt;		/*//number of symbols output */
int trm;		/*//termination char */
int wcnt;		/*//words output */
int pfn;		/*//print file descriptor */

#define EOLC '\n'		/*//end of line character */
#define EOF	0			/*//end of file indicator */

int instrlen[];		/*//length of each instr format */
int format;
int sbuflen;		/*//number of chars in sbuf */
int sbufix;			/*//temp index */
int itfn;			/*//it file number */
int sabort;			/*//abort the assembly flag */
int opix;			/*//index thru stbuf */
int prtflg;			/*//print output flag */
int oitcnt;			/*//count of it buffers written */
int iitcnt;			/*//count of it buffers read */
