/*
 * Floppy address test
 * Peter Collinson - May 1977
 */

int times 1;
extern int errno;
int buf[256];
int fd;

main(argc, argv)
int argc; char **argv;
{
	if(argc == 3)
	{	argv++;
		times =- atoi(*argv);
	}
	argv++;

	if((fd = open(*argv, 2)) < 0)
	{	printf("Cannot open: %s\n", *argv);
		exit();
	}

	while(times--)
	{	writeaddrs();
		readaddrs();
	}
}

writeaddrs()
{	register int blk,ct;
	printf("Writing addresses\n");
	seek(fd, 0, 0);

	for(blk = 0; blk<500;blk++)
	{
		for(ct=0; ct<256; ct++)
		buf[ct] = ((blk&0377)<<8)+ct;	
		if(write(fd, buf, 512)<0)
			{	write("Error in writing block %d\n", blk);
				write("Error number = %o\n", errno);
			}
	}
}

readaddrs()
{	register int blk,ct;
	printf("Reading addresses\n");

	seek(fd,0,0);

	for(blk= 0;blk<500;blk++)
	{	if(read(fd, buf, 512)<0)
		{	printf("Error in reading block %d\n", blk);
			write("Error number = %o\n", errno);
		}
		else
		{	for(ct=0; ct<256; ct++)
				if(buf[ct] != ((blk&0377)<<8)+ct)
			printf("Data error block %d wd %d\n",blk,ct);
		}
	}
}
