#

/*
 *  Glasgow RK disk handler
 */

#include	"../param.h"
#include	"../buf.h"
#include	"../disk.h"
#include	"../conf.h"
#include	"../user.h"
#include	"rk.h"

#define	RKADDR		0177400
/* Number of retries on error */
#define	ERRLIM		10

/* Control status register bits */
#define	RESET		0
#define	GO		01
#define	IENABLE		0100
#define	ERROR		0100000

/* Error register bits */
#define	NXSECTOR	040
#define	NXCYL		0100
#define	NXDISK		0200
#define	DATALATE	01000
#define	WLOVIOLATE	020000
#define	DRIVERROR	0100000

struct	{
	int	rk_dsr;
	int	rk_er;
	int	rk_csr;
	int	rk_wcr;
	int	rk_cbar;
	int	rk_dar;
	};

struct devtab	rktab;
struct buf	rrkbuf;
int		rk_init		1;

/* Masks for decoding the minor dev no */
#define	PORT	07
#define	LDISK	017
/* Synonym for the first pdisk address field */
#define	dar	p_addr1


rkstrategy( abp )
struct buf	*abp;
	{
	register struct buf	*bp;
	register struct pdisk	*pdp;
	register int		drive;
	int			ldisk;

	bp = abp;
	/* Check the minor dev no */
	drive =  bp->b_dev &PORT;
	ldisk =  (bp->b_dev &LDISK) >>2;
	pdp =  &rkdisks[drive];
	if ( drive>= NRKDEV  ||  ldisk>= pdp->p_nldisks )
		bp->b_flags =| B_ERROR;
	diskstrategy( pdp, &(pdp->p_ldisks)[ldisk], bp );
	}



rkstart( apdp )
struct pdisk	*apdp;
	{
	register struct pdisk	*pdp;
	register int		blk;

	pdp = apdp;
	diskflip( pdp, 24 );
	blk = pdp->p_addr2;
	pdp->dar =  (pdp->p_buf->b_dev &PORT)<<13
			| (pdp->p_ldp->l_locyl +pdp->p_addr1)<<5
			| (blk/12)<<4  | (blk%12);
	if ( rk_init )  {
		rk_init = 0;
		RKADDR->rk_csr =  RESET |GO;
		rktab.d_actl = &rktab;
		}
	/* Put it in the queue for a transfer */
	rktab.d_actl->d_actf = pdp;
	rktab.d_actl = pdp;
	pdp->d_actf = 0;
	rkrwstart();
	}



rkrwstart()
	{
	register struct pdisk	*pdp;
	register int		sps;

	sps = PS->integ;
	spl5();
	if ( rktab.d_active == 0
			&&  (pdp= rktab.d_actf) != 0 )  {
		rktab.d_active++;
		devstart( pdp->p_buf, &RKADDR->rk_dar, pdp->dar, 0 );
		}
	PS->integ = sps;
	}



rkintr()
	{
	register struct pdisk	*pdp;
	register int		error, stat;

	if ( rktab.d_active == 0 )
		return;
	rktab.d_active = 0;
	pdp = rktab.d_actf;
	stat = 0;
	if ( RKADDR->rk_csr &ERROR )  {
		error =  RKADDR->rk_er;
		RKADDR->rk_csr =  RESET |GO;
		if ( error &(DRIVERROR|NXDISK|NXCYL|NXSECTOR) )
			stat = ENXIO;
		else  if ( error &DATALATE  ||
		    diskfail( pdp, error, RKADDR->rk_wcr ) < ERRLIM )  {
			rkrwstart();
			return;
			}
		else	stat = EIO;
		}
	diskfinish( &rktab, stat, RKADDR->rk_wcr );
	rkrwstart();
	}



rkread( dev )
int	dev;
	{
	physio( rkstrategy, &rrkbuf, dev, B_READ );
	}



rkwrite( dev )
int	dev;
	{
	physio( rkstrategy, &rrkbuf, dev, B_WRITE );
	}
